<?php

defined('ADVANCED_PRODUCT') or exit();

use Advanced_Product\AP_Functions;
use Advanced_Product\AP_Templates;
use Advanced_Product\Helper\AP_Helper;
use Advanced_Product\Helper\AP_Custom_Field_Helper;
use TemPlazaFramework\Functions;
if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' )){
    $hotelian_options = array();
}else{
    $hotelian_options = Functions::get_theme_options();
}
if(isset($_GET['columns'])){
    $ap_col = $ap_col_large = $ap_col_laptop = intval($_GET['columns']);
}else{
    $ap_col_laptop       = isset($hotelian_options['ap_product-column-laptop'])?$hotelian_options['ap_product-column-laptop']:3;
    $ap_col_large        = isset($hotelian_options['ap_product-column-large'])?$hotelian_options['ap_product-column-large']:3;
    $ap_col              = isset($hotelian_options['ap_product-column'])?$hotelian_options['ap_product-column']:3;
}
$ap_layout           = isset($hotelian_options['ap_product-layout'])?$hotelian_options['ap_product-layout']:'grid';
$ap_col_tablet       = isset($hotelian_options['ap_product-column-tablet'])?$hotelian_options['ap_product-column-tablet']:2;
$ap_col_mobile       = isset($hotelian_options['ap_product-column-mobile'])?$hotelian_options['ap_product-column-mobile']:1;
$ap_col_gap          = isset($hotelian_options['ap_product-column-gap'])?$hotelian_options['ap_product-column-gap']:'';
$grid_view  = isset($_REQUEST['archive_view'])?$_REQUEST['archive_view']:($ap_layout == 'masonry'?'grid':$ap_layout);

$ap_switch_layout       = isset($hotelian_options['ap_product-archive-layout-switch'])?filter_var($hotelian_options['ap_product-archive-layout-switch'], FILTER_VALIDATE_BOOLEAN):true;
$ap_result       = isset($hotelian_options['ap_product-archive-product-result'])?filter_var($hotelian_options['ap_product-archive-product-result'], FILTER_VALIDATE_BOOLEAN):true;
$ap_sortby       = isset($hotelian_options['ap_product-archive-product-sortby'])?filter_var($hotelian_options['ap_product-archive-product-sortby'], FILTER_VALIDATE_BOOLEAN):true;
$ap_list_grid       = isset($hotelian_options['ap_product-archive-product-list-grid'])?filter_var($hotelian_options['ap_product-archive-product-list-grid'], FILTER_VALIDATE_BOOLEAN):true;
$ap_cat_description       = isset($hotelian_options['ap_product-cat-description'])?$hotelian_options['ap_product-cat-description']:'top';
$ap_sortby_full     = array('date_high','date_low','title_low','title_high','price_high','price_low','price_rental_high','price_rental_low');
$ap_sortby_hidden       = isset($hotelian_options['ap_product-archive-product-sortby-hidden'])?$hotelian_options['ap_product-archive-product-sortby-hidden']:array();
$grid_option = '';
if($ap_layout == 'masonry'){
    $grid_option = 'masonry: true';
}elseif($ap_layout == 'list' || $grid_view =='list'){
    $ap_col_laptop = $ap_col_large = $ap_col = $ap_col_tablet = $ap_col_mobile = '1';
}else{
    $grid_option = '';
}
$post_count = $GLOBALS['wp_query']->found_posts;
if(!is_post_type_archive('ap_product')){
    $cat_id         = get_queried_object()->term_id;
    if($ap_cat_description == 'top'){
    ?>
    <div class="ap-archive-descirtion uk-margin-medium-bottom">
        <?php
        echo wp_kses(term_description($cat_id),'post');
        ?>
    </div>
    <?php
    }
}
if ( have_posts()) {
    ?>
    <div class="templaza-ap-product-filter uk-margin-bottom uk-flex uk-flex-right uk-hidden@m uk-text-right  uk-position-z-index" data-uk-sticky="start: 20vh; end: !.templaza-content_area; offset: 30vh">
        <span class="ap-filter-btn"><i class="fas fa-sliders-h"></i><?php esc_html_e('Filter','hotelian');?></span>
    </div>
    <?php if($ap_switch_layout){
      ?>
        <div class="uk-flex uk-grid-collapse uk-flex-middle uk-flex-between templaza-ap-archive-view uk-grid" data-uk-grid>
            <?php
            if($ap_result){
                ?>
                <div class="uk-width-1-3@s uk-flex ap-number-product">
                    <h3 class="uk-margin-remove"><span><?php
                            printf(
                                _n('%d Room available', '%d Rooms available', $post_count, 'hotelian'),
                                $post_count
                            );
                            ?></span></h3>
                </div>
                <?php
            }
            ?>
            <div class="uk-width-2-3@s uk-flex uk-flex-middle uk-flex-between uk-flex-right@s">
                <?php
                if($ap_sortby){
                    ?>
                    <div class="templaza-ap-archive-sort uk-flex uk-flex-middle">
                        <label class="uk-width-auto"><?php echo esc_html__('Sort By', 'hotelian')?></label>
                        <div class="uk-form-controls">
                            <select name="ap-archive-sort">
                                <?php
                                foreach ($ap_sortby_full as $sortby_item){
                                    if(!in_array($sortby_item,$ap_sortby_hidden)){
                                        if($sortby_item=='date_high'){
                                            ?>
                                            <option value="date_high"><?php echo esc_html__('Date: Newest First', 'hotelian')?></option>
                                            <?php
                                        }
                                        if($sortby_item=='date_low'){
                                            ?>
                                            <option value="date_low"><?php echo esc_html__('Date: Oldest First', 'hotelian')?></option>
                                            <?php
                                        }
                                        if($sortby_item=='title_low'){
                                            ?>
                                            <option value="title_low"><?php echo esc_html__('Title: A - Z', 'hotelian')?></option>
                                            <?php
                                        }
                                        if($sortby_item=='title_high'){
                                            ?>
                                            <option value="title_high"><?php echo esc_html__('Title: Z - A', 'hotelian')?></option>
                                            <?php
                                        }
                                        if($sortby_item=='price_high'){
                                            ?>
                                            <option value="price_high"><?php echo esc_html__('Price: High To Low', 'hotelian')?></option>
                                            <?php
                                        }
                                        if($sortby_item=='price_low'){
                                            ?>
                                            <option value="price_low"><?php echo esc_html__('Price: Low To High', 'hotelian')?></option>
                                            <?php
                                        }
                                        if($sortby_item=='price_rental_high'){
                                            ?>
                                            <option value="price_rental_high"><?php echo esc_html__('Price Rental: High To Low', 'hotelian')?></option>
                                            <?php
                                        }
                                        if($sortby_item=='price_rental_low'){
                                            ?>
                                            <option value="price_rental_low"><?php echo esc_html__('Price Rental: Low To High', 'hotelian')?></option>
                                            <?php
                                        }
                                    }
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <?php
                }
                if($ap_list_grid){
                    ?>
                    <div class="ap-switcher-wrap uk-flex uk-flex-right uk-text-right" data-uk-switcher data-ap-archive-view="<?php echo esc_attr($grid_view);?>">
                        <span class="switcher_btn grid<?php echo esc_attr($grid_view == 'grid'?' uk-active':'');?>" data-uk-icon="grid" data-ap-archive-view-item="grid"></span>
                        <span class="switcher_btn uk-visible@s list<?php echo esc_attr($grid_view == 'list'?' uk-active':'');?>" data-uk-icon="list" data-ap-archive-view-item="list"></span>
                    </div>
                    <?php
                }
                ?>
            </div>
            <div class="active-filters"></div>
        </div>
    <?php
    }
    ?>
<div class="templaza-ap-archive templaza-ap-grid
  uk-child-width-1-<?php echo esc_attr($ap_col);?>@l
  uk-child-width-1-<?php echo esc_attr($ap_col_large);?>@xl
  uk-child-width-1-<?php echo esc_attr($ap_col_laptop);?>@m
  uk-child-width-1-<?php echo esc_attr($ap_col_tablet);?>@s
  uk-child-width-1-<?php echo esc_attr($ap_col_mobile);?>
  uk-grid-<?php echo esc_attr($ap_col_gap);?>
 " data-uk-grid="<?php echo esc_attr($grid_option);?>">
    <?php
    if($grid_view == 'list'){
        AP_Templates::load_my_layout('archive.content-list');
    }else{
        AP_Templates::load_my_layout('archive.content');
    }
    ?>
</div>
<div class="templaza-blog-pagenavi uk-margin-large-top">
    <?php
    do_action('hotelian_pagination');
    ?>
</div>
<?php
}
if(!is_post_type_archive('ap_product')){
    $cat_id         = get_queried_object()->term_id;
    if($ap_cat_description == 'bottom'){
        ?>
        <div class="ap-archive-descirtion uk-margin-medium-bottom">
            <?php
            echo wp_kses(term_description($cat_id),'post');
            ?>
        </div>
        <?php
    }
}
?>