(function ($) {
    'use strict';
    var hotelian_woo = hotelian_woo || {};
    hotelian_woo.init = function () {
        hotelian_woo.$body = $(document.body),
            hotelian_woo.$window = $(window);

        // Catalog
        this.productsLoading();
        this.productsInfinite();
        this.filter_btn();
    };
    hotelian_woo.productsLoading = function () {
        hotelian_woo.$body.on('click', '#templaza-catalog-previous-ajax > a', function (e) {
            e.preventDefault();

            var $this = $(this);
            if ($this.data('requestRunning')) {
                return;
            }

            $this.data('requestRunning', true);

            var $wrapper = $this.closest('.templaza-shop-container'),
                $products = $wrapper.find('.products'),
                $pagination = $wrapper.find('.next-posts-navigation'),
                numberPosts = $products.children('.product').length,
                href = $this.attr('href');

            $pagination.addClass('loading');

            $.get(
                href,
                function (response) {
                    var content = $(response).find('#templaza-shop-container').find('.products').children('.product');

                    // Add animation class
                    for (var index = 0; index < content.length; index++) {
                        $(content[index]).css('animation-delay', index * 100 + 'ms');
                    }
                    content.addClass('TemplazaFadeInUp');
                    if ($(response).find('.next-posts-navigation').length > 0) {
                        $pagination.html($(response).find('.next-posts-navigation').html());
                    } else {
                        $pagination.fadeOut();
                    }
                    $products.append(content);
                    $pagination.find('.nav-previous-ajax > a').data('requestRunning', false);

                    numberPosts += content.length;
                    $wrapper.find('.templaza-posts__found .current-post').html(' ' + numberPosts);
                    hotelian_woo.postsFound();
                    $pagination.removeClass('loading');
                    $(document.body).trigger('templaza_products_loaded', [content, true]);
                }
            );
        });
    };
    hotelian_woo.filter_btn = function () {
        if($('#templaza-shop-container').length){
            if($('.products-filter-widget').parents('.templaza-column').hasClass('hideonsm')){
                $('.shop-filter-btn').addClass('hello');
            }
        }
        hotelian_woo.$body.on('click', '.shop-filter-btn', function (e) {
            e.preventDefault();
            var $this = $(this);
            if ($this.data('requestRunning')) {
                return;
            }
        });
    };
    hotelian_woo.postsFound = function () {
        var $found = $('.templaza-posts__found-inner'),
            $foundEls = $found.find('.count-bar'),
            $current = $found.find('.current-post').html(),
            $total = $found.find('.found-post').html(),
            pecent = ($current / $total) * 100;

        $foundEls.css('width', pecent + '%');
    };
    hotelian_woo.productsInfinite = function () {
        if (!$('.woocommerce-navigation').hasClass('ajax-scroll')) {
            return;
        }
        hotelian_woo.$window.on('scroll', function () {
            if (hotelian_woo.$body.find('#templaza-catalog-previous-ajax').is(':in-viewport')) {
                hotelian_woo.$body.find('#templaza-catalog-previous-ajax > a').trigger('click');
            }
        }).trigger('scroll');
    };

    $(function () {
        hotelian_woo.init();
    });

})(jQuery);