<?php

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
    return;
}
?>

<div id="comments" class="comments-area templaza-comment-form ">
    <?php
    // You can start editing here -- including this comment!
    if ( have_comments() ) :
        ?>
        <h3 class="comments-title box-title uk-margin-medium-bottom">
            <?php
            $hotelian_comment_count = get_comments_number();
            if ( '1' === $hotelian_comment_count ) {
                ?>
                <span>
                    <?php
                    echo number_format_i18n( $hotelian_comment_count );
                    ?>
                </span>
            <span><?php echo esc_html__('Comment','hotelian')?></span>
            <?php
            } else {
                ?>
                <span>
                <?php
                echo number_format_i18n( $hotelian_comment_count );
                ?>
                </span>
                <span><?php echo esc_html__('Comments','hotelian')?></span>
            <?php
            }
            ?>
        </h3><!-- .comments-title -->

        <?php the_comments_navigation(); ?>

        <ol class="comment-list">
            <?php
            wp_list_comments( array(
	            'style'      => 'ol',
	            'short_ping' => true,
	            'avatar_size' => 75,
            ) );
            ?>
        </ol><!-- .comment-list -->

        <?php
        the_comments_navigation();

        // If comments are closed and there are comments, let's leave a little note, shall we?
        if ( ! comments_open() ) :
            ?>
            <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'hotelian' ); ?></p>
        <?php
        endif;

    endif; // Check for have_comments().
    ?>

    <div class="CommentForm">
        <?php
        $hotelian_commenter = wp_get_current_commenter();
        $hotelian_req      = get_option( 'require_name_email' );
        $hotelian_aria_req = ( $hotelian_req ? " aria-required='true'" : '' );
        $hotelian_comment_title = esc_html__( 'Leave a Comment','hotelian').'';
        if(!is_user_logged_in()){
            $hotelian_args = array(
                'fields' => apply_filters( 'comment_form_default_fields',
                    array(
                        '<div class="content-form uk-child-width-1-2@s uk-grid-small " data-uk-grid>',
                        'author' => '<div class=" comment-form-author ">'
                            . '<input id="author" name="author" type="text" value="' . esc_attr( $hotelian_commenter['comment_author'] ) . '" size="30"' . $hotelian_aria_req . ' placeholder="'.esc_attr__('Enter your name...','hotelian').'" /></div>',
                        'email'  => '<div class=" comment-form-email ">'
                            . '<input id="comment-email" name="email" type="text" value="' . esc_attr(  $hotelian_commenter['comment_author_email'] ) . '" size="30" aria-describedby="email-notes"' . $hotelian_aria_req . ' placeholder="'.esc_attr__('Email','hotelian').'" /></div>',
                        '</div>',
                    )
                ),
                'comment_field'        => '<div class="comment-form-comment"><textarea id="comment" name="comment" cols="90" rows="4" required="required" placeholder="'.esc_attr__('Your Comment...','hotelian').'"></textarea></div>',
                'label_submit'      =>  esc_html__( 'Post Comment','hotelian'),
                'title_reply_before' => '<h3 id="reply-title" class="comment-reply-title box-title">',
                'title_reply_after' => '</h3>',
                'title_reply'       =>  $hotelian_comment_title,
                'class_submit'  =>'templaza-btn'
            );
        }else{
            $hotelian_args = array(
                'fields' => apply_filters( 'comment_form_default_fields',
                    array(
                        '<div class="content-form ">',
                        'author' => '<div class="comment-form-author">'
                            .'<label>'.( $hotelian_req ? esc_html__('Your Name','hotelian') : '' ).'</label>'
                            . '<input id="author" name="author" type="text" value="' . esc_attr( $hotelian_commenter['comment_author'] ) . '" size="30"' . $hotelian_aria_req . ' /></div>',
                        'email'  => '<div class="comment-form-email">'
                            .'<label>'.( $hotelian_req ? esc_html__('Your Email','hotelian') : '' ).'</label>'
                            . '<input id="comment-email" name="email" type="text" value="' . esc_attr(  $hotelian_commenter['comment_author_email'] ) . '" size="30" aria-describedby="email-notes"' . $hotelian_aria_req . ' /></div>',
                        '</div>'
                    )
                ),
                'comment_field'        => '<div class="comment-form-comment login"><label>'.esc_html__('Comment','hotelian').'</label> <textarea id="comment" name="comment" cols="90" rows="4" required="required"></textarea></div>',
                'label_submit'      =>  esc_html__( 'Post Comment','hotelian'),
                'title_reply'       =>  $hotelian_comment_title,
                'title_reply_before' => '<h3 id="reply-title" class="comment-reply-title box-title">',
                'title_reply_after' => '</h3>',
                'class_submit'  =>'templaza-btn'
            );
        }

        comment_form( $hotelian_args ); ?>
    </div>

</div><!-- #comments -->
