<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Hotelian
 * @since Hotelian 1.0
 */
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<?php wp_head(); ?>
</head>
<?php
$body_cl = ' ';
if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' ) ) {
    $body_cl = ' body-basic-wrap';
}
if ( is_user_logged_in() ) {
    $body_cl .= ' user_login ';
}
?>
<body <?php body_class($body_cl); ?> >
<?php
if (class_exists('\Elementor\Plugin') && \Elementor\Plugin::$instance->preview->is_preview_mode()) {

}else{
?>
<div class="templaza-loading-body">
    <div class="templaza-loading-inner">
        <div class="preloader-inner">
            <div class="preloader-border">
                <img class="loading-img-rotate" src="<?php echo esc_url(get_template_directory_uri()).'/assets/images/loading-rotate.svg';?>"/>
            </div>
            <img class="loading-img" src="<?php echo esc_url(get_template_directory_uri()).'/assets/images/loading-bg1.svg';?>"/>
        </div>
    </div>
</div>
<?php
}
 ?>
<?php wp_body_open(); ?>
<?php
if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' ) ) {
    get_template_part('inc/header');
}
?>