<?php
global $content_width;
if ( ! isset( $content_width ) ) {
	$content_width = 580;
}
if ( ! function_exists( 'hotelian_basic_fonts_url' ) ) {
	function hotelian_basic_fonts_url()
	{
		$hotelian_fonts_url = '';
		$hotelian_font_families = array();
		$font_subsets = 'latin,latin-ext';

		/* translators: If there are characters in your language that are not supported by Barlow, translate this to 'off'. Do not translate into your own language. */
		if ('off' !== esc_html_x('on', 'Jost: on or off', 'hotelian')) {
			$hotelian_font_families[] = 'Jost:400,500,600,700';
		}

		/* translators: If there are characters in your language that are not supported by Saira, translate this to 'off'. Do not translate into your own language. */
		if ('off' !== esc_html_x('on', 'Marcellus: on or off', 'hotelian')) {
			$hotelian_font_families[] = 'Marcellus:400';
		}

		/* translators: If there are characters in your language that are not supported by Saira, translate this to 'off'. Do not translate into your own language. */
		if ('off' !== esc_html_x('on', 'Lora: on or off', 'hotelian')) {
			$hotelian_font_families[] = 'Lora:400, 500';
		}

		if ($hotelian_font_families) {

			$hotelian_query_args = array(
				'family' => implode('|', $hotelian_font_families),
			);

			$hotelian_fonts_url = add_query_arg($hotelian_query_args, 'https://fonts.googleapis.com/css');
		}
		return esc_url_raw($hotelian_fonts_url);
	}
}

if ( !function_exists('hotelian_basic_continue_reading_text') ) {
	function hotelian_basic_continue_reading_text() {
		$continue_reading = sprintf(
		/* translators: %s: Name of current post. */
			esc_html__( 'Continue reading %s', 'hotelian' ),
			the_title( '<span class="screen-reader-text">', '</span>', false )
		);

		return $continue_reading;
	}
}