<?php
defined('ABSPATH') or exit();
use Advanced_Product\Helper\AP_Helper;
$hotelian_breadcrums_id      = 'breadcrumb';
$hotelian_breadcrums_class   = 'templaza-breadcrumb uk-breadcrumb';
$hotelian_blog_title         = esc_html__('Blog','hotelian');
$hotelian_home_title         = esc_html__('Home','hotelian');
/* If you have any custom post types with custom taxonomies, put the taxonomy name below (e.g. product_cat) */
$hotelian_product_taxonomy    = array('product_cat','ap_category');

/* Get the query & post information */
global $post,$wp_query;

/* Do not display on the homepage */
if ( !is_front_page() ) {
    /* Build the breadcrums */
    echo '<ul id="' . esc_attr($hotelian_breadcrums_id) . '" class="' . esc_attr($hotelian_breadcrums_class) . '">';

    /* Home page */
    echo '<li class="item-home"><a href="' . esc_url(get_home_url()) . '" title="' . esc_attr($hotelian_home_title) . '">' . esc_html($hotelian_home_title) . '</a></li>';

    if ( is_archive() && !is_tax() && !is_category() && !is_tag() && !is_author() ) {

        /* Blog page */
        if( get_option( 'page_for_posts' ) != '0' ){
            echo '<li class="item-blog"><a href="' . esc_url(get_permalink( get_option( 'page_for_posts' ))) . '" title="' . esc_attr($hotelian_blog_title) . '">' . esc_html($hotelian_blog_title) . '</a></li>';
        }
        if(is_month()){
            ?>
            <li class="item-current item-archive monthly-archive"><span class="bread-current bread-archive"><?php  single_month_title('&nbsp;'); ?></span></li>
            <?php
        }else{
            if(is_post_type_archive( 'product' )){
                if(class_exists( 'woocommerce' )) {
                    if ( is_shop() ) {
                        $title =  woocommerce_page_title(false);
                    }else{
                        $title = post_type_archive_title( '', false);
                    }
                    echo '<li class="item-current item-archive"><span class="bread-current bread-archive">' . $title . '</span></li>';
                }
            }elseif(is_post_type_archive( 'ap_product' )){
                if ( AP_Helper::is_inventory() ) {
                    $inventory_page_id = AP_Helper::get_page_id('inventory');
                    $title =  get_the_title($inventory_page_id);
                    if($title==''){
                        $title = post_type_archive_title( '', false);
                    }
                }else{
                    $title = post_type_archive_title( '', false);
                }
                echo '<li class="item-current item-archive"><span class="bread-current bread-archive">' . $title . '</span></li>';
            }else{
                echo '<li class="item-current item-archive"><span class="bread-current bread-archive">' . esc_html(post_type_archive_title('', false)) . '</span></li>';
            }
        }

    } elseif ( is_archive() && is_tax() && !is_category() && !is_tag() ) {

        /* If post is a custom post type */
        $hotelian_post_type = get_post_type();

        /* If it is a custom post type display name and link */
        if($hotelian_post_type != 'post' && $hotelian_post_type !=null) {

            /* Blog page */
            if( get_option( 'page_for_posts' ) != '0' && $hotelian_post_type == 'post' ){
                echo '<li class="item-blog"><a href="' . esc_url(get_permalink( get_option( 'page_for_posts' ))) . '" title="' . esc_attr($hotelian_blog_title) . '">' . esc_html($hotelian_blog_title) . '</a></li>';
            }

            $hotelian_post_type_object = get_post_type_object($hotelian_post_type);
            $hotelian_post_type_archive = get_post_type_archive_link($hotelian_post_type);

            echo '<li class="item-cat item-custom-post-type-' . esc_attr($hotelian_post_type) . '"><a href="' . esc_url($hotelian_post_type_archive) . '" title="' . esc_attr($hotelian_post_type_object->labels->name) . '">' . esc_html($hotelian_post_type_object->labels->name) . '</a></li>';

        }
        if(is_post_type_archive( 'ap_product' ) || is_tax( get_query_var('taxonomy') )){
            foreach($hotelian_product_taxonomy as $taxonomy_item){
                $hotelian_taxonomy_exists = taxonomy_exists($taxonomy_item);
                $hotelian_taxonomy_terms = get_the_terms( $post->ID, $taxonomy_item );
                if($hotelian_taxonomy_exists && !empty($hotelian_taxonomy_terms)) {

                    $hotelian_taxonomy_terms = get_the_terms( $post->ID, $taxonomy_item );
                    $hotelian_cat_id         = get_queried_object()->term_id;
                    $hotelian_cat_name       = get_queried_object()->name;
                    $hotelian_get_term_parent = rtrim(get_term_parents_list($hotelian_cat_id,$taxonomy_item,array( 'separator' => ',' )),',');
                    $hotelian_term_parents = explode(',',$hotelian_get_term_parent);
                    if(count($hotelian_term_parents)>1){
                        $d=1;
                        foreach($hotelian_term_parents as $hotelian_parents) {
                            if($d <count($hotelian_term_parents)){
                                echo '<li class="item-cat">'.ent2ncr($hotelian_parents).'</li>';
                            }else{
                                echo '<li class="item-current  item-archive"><span class="bread-current bread-archive">' . esc_html($hotelian_cat_name) . '</span></li>';
                            }
                            $d++;
                        }
                    }else{
                        echo '<li class="item-current  item-archive"><span class="bread-current bread-archive">' . esc_html($hotelian_cat_name) . '</span></li>';
                    }
                }
            }
        }else{
            $hotelian_custom_tax_name = get_queried_object()->name;
            echo '<li class="item-current  item-archive"><span class="bread-current bread-archive">' . esc_html($hotelian_custom_tax_name) . '</span></li>';
        }
    }
    elseif ( is_single() ) {

        /* If post is a custom post type */
        $hotelian_post_type = get_post_type();

        /* Blog page */
        if( get_option( 'page_for_posts' ) != '0' && $hotelian_post_type == 'post' ){
            echo '<li class="item-blog"><a href="' . esc_url(get_permalink( get_option( 'page_for_posts' ))) . '" title="' . esc_attr($hotelian_blog_title) . '">' . esc_html($hotelian_blog_title) . '</a></li>';
        }

        /* If it is a custom post type display name and link */
        if($hotelian_post_type != 'post') {
            $hotelian_post_type_object = get_post_type_object($hotelian_post_type);
            $hotelian_post_type_archive = get_post_type_archive_link($hotelian_post_type);
            if($hotelian_post_type =='product'){
                if(class_exists( 'woocommerce' )) {
                    $title =  woocommerce_page_title(false);
                    if($title==''){
                        $title = post_type_archive_title( '', false);
                    }
                    echo '<li class="item-cat item-custom-post-type-' . esc_attr($hotelian_post_type) . '"><a href="' . esc_url($hotelian_post_type_archive) . '" title="' . esc_attr($title) . '">' . esc_html($title) . '</a></li>';
                }
            }elseif($hotelian_post_type =='ap_product'){
                $inventory_page_id = AP_Helper::get_page_id('inventory');
                $title =  get_the_title($inventory_page_id);
                if($title==''){
                    $title = post_type_archive_title( '', false);
                }
                echo '<li class="item-cat item-custom-post-type-' . esc_attr($hotelian_post_type) . '"><a href="' . esc_url($hotelian_post_type_archive) . '" title="' . esc_attr($title) . '">' . esc_html($title) . '</a></li>';
            }else{
                if($hotelian_post_type_archive != false){
                    echo '<li class="item-cat item-custom-post-type-' . esc_attr($hotelian_post_type) . '"><a href="' . esc_url($hotelian_post_type_archive) . '" title="' . esc_attr($hotelian_post_type_object->labels->name) . '">' . esc_html($hotelian_post_type_object->labels->name) . '</a></li>';
                }
            }

        }

        /* Get post category info */
        $hotelian_category = get_the_category();

        if(!empty($hotelian_category)) {

            /* Get last category post is in */
            $hotelian_category_array = array_values($hotelian_category);
            $hotelian_last_category = end($hotelian_category_array);

            /* Get parent any categories and create array */
            $hotelian_get_cat_parents = rtrim(get_category_parents($hotelian_last_category->term_id, true, ','),',');
            $hotelian_cat_parents = explode(',',$hotelian_get_cat_parents);

            /* Loop through parent categories and store in variable $hotelian_cat_display */
            $hotelian_cat_display = '';
            foreach($hotelian_cat_parents as $hotelian_parents) {
                $hotelian_cat_display .= '<li class="item-cat">'.ent2ncr($hotelian_parents).'</li>';
            }
        }

        /* If it's a custom post type within a custom taxonomy */
        foreach($hotelian_product_taxonomy as $taxonomy_item){
            $hotelian_taxonomy_exists = taxonomy_exists($taxonomy_item);
            $hotelian_taxonomy_terms = get_the_terms( $post->ID, $taxonomy_item );
            if($hotelian_taxonomy_exists && !empty($hotelian_taxonomy_terms)) {

                $hotelian_taxonomy_terms = get_the_terms( $post->ID, $taxonomy_item );
                $hotelian_cat_id         = $hotelian_taxonomy_terms[0]->term_id;
                $hotelian_cat_nicename   = $hotelian_taxonomy_terms[0]->slug;
                $hotelian_cat_link       = get_term_link($hotelian_taxonomy_terms[0]->term_id, $taxonomy_item);
                $hotelian_cat_name       = $hotelian_taxonomy_terms[0]->name;

            }
        }


        /* Check if the post is in a category */
        if(!empty($hotelian_last_category)) {
            if( !empty($hotelian_cat_display) ){
                echo ent2ncr($hotelian_cat_display);
            }

            /* Else if post is in a custom taxonomy */
        } elseif(!empty($hotelian_cat_id)) {

            echo '<li class="item-cat item-cat-' . esc_attr($hotelian_cat_id) . ' item-cat-' . esc_attr($hotelian_cat_nicename) . '"><a href="' . esc_url($hotelian_cat_link) . '" title="' . esc_attr($hotelian_cat_name) . '">' . esc_html($hotelian_cat_name) . '</a></li>';

        }
        echo '<li class="item-current item-' . esc_attr($post->ID) . '"><span class="bread-current bread-' . esc_attr($post->ID) . '"> ' . wp_kses(get_the_title(),'post') . '</span></li>';

    } elseif ( is_category() ) {
        /* Blog page */
        if( get_option( 'page_for_posts' ) != '0' ){
            echo '<li class="item-blog"><a href="' . esc_url(get_permalink( get_option( 'page_for_posts' ))) . '" title="' . esc_attr($hotelian_blog_title) . '">' . esc_html($hotelian_blog_title) . '</a></li>';
        }
        /* Category page */
        echo '<li class="item-current item-cat"><span class="bread-current bread-cat">' . esc_html(single_cat_title('', false)) . '</span></li>';

    } elseif ( is_page() ) {

        /* Standard page */
        if( $post->post_parent ){

            /* If child page, get parents */
            $hotelian_anc = get_post_ancestors( $post->ID );

            /* Get parents in the right order */
            $hotelian_anc = array_reverse($hotelian_anc);

            /* Parent page loop */
            if ( !isset( $hotelian_parents ) ) $hotelian_parents = null;
            foreach ( $hotelian_anc as $hotelian_ancestor ) {
                $hotelian_parents .= '<li class="item-parent item-parent-' . esc_attr($hotelian_ancestor) . '"><a href="' . esc_url(get_permalink($hotelian_ancestor)) . '" title="' . esc_attr(get_the_title($hotelian_ancestor)) . '">' . esc_html(get_the_title($hotelian_ancestor)) . '</a></li>';
            }

            /* Display parent pages */
            echo ent2ncr($hotelian_parents);

            /* Current page */
            echo '<li class="item-current item-' . esc_attr($post->ID) . '"><span title="' . esc_attr(get_the_title()) . '"> ' . get_the_title() . '</span></li>';

        } else {

            /* Just display current page if not parents */
            echo '<li class="item-current item-' . esc_attr($post->ID) . '"><span class="bread-current bread-' . esc_attr($post->ID) . '"> ' . get_the_title() . '</span></li>';

        }

    } elseif ( is_tag() ) {

        /* Get tag information */
        $hotelian_term_id        = get_query_var('tag_id');
        $hotelian_taxonomy       = 'post_tag';
        $hotelian_args           = 'include=' . $hotelian_term_id;
        $hotelian_terms          = get_terms( $hotelian_taxonomy, $hotelian_args );
        $hotelian_get_term_id    = $hotelian_terms[0]->term_id;
        $hotelian_get_term_slug  = $hotelian_terms[0]->slug;
        $hotelian_get_term_name  = $hotelian_terms[0]->name;

        /* Display the tag name */
        echo '<li class="item-current item-tag-' . esc_attr($hotelian_get_term_id) . ' item-tag-' . esc_attr($hotelian_get_term_slug) . '"><span class="bread-current bread-tag-' . esc_attr($hotelian_get_term_id) . ' bread-tag-' . esc_attr($hotelian_get_term_slug) . '">' . esc_html($hotelian_get_term_name) . '</span></li>';

    } elseif ( is_day() ) {

        /* Day archive */

        /* Year link */
        echo '<li class="item-year item-year-' . esc_attr(get_the_time('Y')) . '"><a href="' . esc_url(get_year_link( get_the_time('Y') )) . '" title="' . esc_attr(get_the_time('Y')) . '">' . esc_html(get_the_time('Y')) . esc_html__(' Archives','hotelian') . '</a></li>';

        /* Month link */
        echo '<li class="item-month item-month-' . esc_attr(get_the_time('m')) . '"><a href="' . esc_url(get_month_link( get_the_time('Y'), get_the_time('m') )) . '" title="' . esc_attr(get_the_time('M')) . '">' . esc_html(get_the_time('M')) . esc_html__(' Archives','hotelian') . '</a></li>';

        /* Day display */
        echo '<li class="item-current item-' . esc_attr(get_the_time('j')) . '"><span class="bread-current bread-' . esc_attr(get_the_time('j')) . '"> ' . esc_html(get_the_time('jS')) . ' ' . esc_html(get_the_time('M')) . esc_html__(' Archives','hotelian') . '</span></li>';

    } elseif ( is_month() ) {

        /* Month Archive */

        /* Year link */
        echo '<li class="item-year item-year-' . esc_attr(get_the_time('Y')) . '"><a href="' . esc_url(get_year_link( get_the_time('Y') )) . '" title="' . esc_attr(get_the_time('Y')) . '">' . esc_html(get_the_time('Y')) . esc_html__(' Archives','hotelian') . '</a></li>';

        /* Month display */
        echo '<li class="item-month item-month-' . esc_attr(get_the_time('m')) . '"><span class="bread-month bread-month-' . esc_attr(get_the_time('m')) . '" title="' . esc_attr(get_the_time('M')) . '">' . esc_html(get_the_time('M')) . esc_html__(' Archives','hotelian') . '</span></li>';

    } elseif ( is_year() ) {

        /* Display year archive */
        echo '<li class="item-current item-current-' . esc_attr(get_the_time('Y')) . '"><span class="bread-current bread-current-' . esc_attr(get_the_time('Y')) . '" title="' . esc_attr(get_the_time('Y')) . '">' . esc_html(get_the_time('Y')) . esc_html__(' Archives','hotelian') . '</span></li>';

    } elseif ( is_author() ) {

        /* Author archive */

        /* Get the author information */
        global $author;
        $hotelian_userdata = get_userdata( $author );

        /* Display author name */
        echo '<li class="item-current item-current-' . esc_attr($hotelian_userdata->user_nicename) . '"><span class="bread-current bread-current-' . esc_attr($hotelian_userdata->user_nicename) . '" title="' . esc_attr($hotelian_userdata->display_name) . '">' . esc_html__('Author: ','hotelian') . esc_html($hotelian_userdata->display_name) . '</span></li>';

    } elseif ( get_query_var('paged') ) {

        /* Paginated archives */
        echo '<li class="item-current item-current-' . esc_attr(get_query_var('paged')) . '"><span class="bread-current bread-current-' . esc_attr(get_query_var('paged')) . '" title="Page ' . esc_attr(get_query_var('paged')) . '">'.esc_html__('Page','hotelian') . ' ' . esc_html(get_query_var('paged')) . '</span></li>';

    } elseif ( is_search() ) {

        /* Search results page */
        echo '<li class="item-current item-current-' . esc_attr(get_search_query()) . '"><span class="bread-current bread-current-' . esc_attr(get_search_query()) . '" title="' . esc_attr__('Search results for: ','hotelian') . esc_attr(get_search_query()) . '">' . esc_html__('Search results for: ','hotelian') . esc_html(get_search_query()) . '</span></li>';

    } elseif ( is_404() ) {

        /* 404 page */
        echo '<li>' . esc_html__('Error 404','hotelian') . '</li>';
    }

    echo '</ul>';
}