<?php
/*
 * Archive Service
 */

defined('TEMPLAZA_FRAMEWORK');
use TemPlazaFramework\Functions;
use TemPlazaFramework\Templates;
use TemPlazaFramework\CSS;
$hotelian_id             = isset($atts['id'])?$atts['id']:time();
$hotelian_custom_class   = isset($atts['custom_container_class'])?' '.$atts['custom_container_class']:'';
if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' )){
    $hotelian_options = array();
}else{
    $hotelian_options            = Functions::get_theme_options();
}
global $wp_query;
$hotelian_post_type      = get_post_type(get_the_ID());

$prefix               = $hotelian_post_type.'-page';

if($hotelian_post_type == 'post'){
    $prefix = 'blog-page';
}
$hotelian_layout        = isset($hotelian_options[$prefix.'-layout'])?$hotelian_options[$prefix.'-layout']:'list';
$hotelian_grid_col      = isset($hotelian_options[$prefix.'-grid-column'])?$hotelian_options[$prefix.'-grid-column']:2;
$hotelian_col_gap      = isset($hotelian_options[$prefix.'-column-gap'])?$hotelian_options[$prefix.'-column-gap']:'collapse';
$hotelian_thumbnail_size= isset($hotelian_options[$prefix.'-thumbnail-size'])?$hotelian_options[$prefix.'-thumbnail-size']:'large';
$hotelian_thumbnail_effect = isset($hotelian_options[$prefix.'-thumbnail-effect'])?$hotelian_options[$prefix.'-thumbnail-effect']:'none';
$hotelian_leading      = isset($hotelian_options[$prefix.'-leading'])?filter_var($hotelian_options[$prefix.'-leading'], FILTER_VALIDATE_BOOLEAN):false;
$hotelian_show_thumbnail     = isset($hotelian_options[$prefix.'-thumbnail'])?filter_var($hotelian_options[$prefix.'-thumbnail'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_title         = isset($hotelian_options[$prefix.'-title'])?filter_var($hotelian_options[$prefix.'-title'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_description   = isset($hotelian_options[$prefix.'-description'])?filter_var($hotelian_options[$prefix.'-description'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_readmore      = isset($hotelian_options[$prefix.'-readmore'])?filter_var($hotelian_options[$prefix.'-readmore'], FILTER_VALIDATE_BOOLEAN):false;
$hotelian_show_share         = isset($hotelian_options[$prefix.'-share'])?filter_var($hotelian_options[$prefix.'-share'], FILTER_VALIDATE_BOOLEAN):false;
$hotelian_show_thumbnail_audio = isset($hotelian_options[$prefix.'-thumb-audio'])?filter_var($hotelian_options[$prefix.'-thumb-audio'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_thumbnail_video = isset($hotelian_options[$prefix.'-thumb-video'])?filter_var($hotelian_options[$prefix.'-thumb-video'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_thumbnail_link = isset($hotelian_options[$prefix.'-thumb-link'])?filter_var($hotelian_options[$prefix.'-thumb-link'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_thumbnail_quote = isset($hotelian_options[$prefix.'-thumb-quote'])?filter_var($hotelian_options[$prefix.'-thumb-quote'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_pagination = isset($hotelian_options[$prefix.'-pagination'])?filter_var($hotelian_options[$prefix.'-pagination'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_category      = isset($hotelian_options[$prefix.'-category'])?filter_var($hotelian_options[$prefix.'-category'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_tag           = isset($hotelian_options[$prefix.'-tag'])?filter_var($hotelian_options[$prefix.'-tag'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_image_cover           = isset($hotelian_options[$prefix.'-image-cover'])?filter_var($hotelian_options[$prefix.'-image-cover'], FILTER_VALIDATE_BOOLEAN):false;
$hotelian_thumbnail_height = isset($hotelian_options[$prefix.'-thumbnail-height'])?$hotelian_options[$prefix.'-thumbnail-height']:300;
$hotelian_card_size = isset($hotelian_options[$prefix.'-card-size'])?$hotelian_options[$prefix.'-card-size']:'';
$hotelian_card_custom = isset($hotelian_options[$prefix.'-card-custom'])?$hotelian_options[$prefix.'-card-custom']:'';
$show_date          = isset($hotelian_options[$prefix.'-date'])?filter_var($hotelian_options[$prefix.'-date'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_cl = '';
if ($hotelian_layout == 'column' || $hotelian_layout == 'grid') {
    $hotelian_layout_cl = 'templaza-blog-grid uk-child-width-1-'.$hotelian_grid_col.'@m';
    $hotelian_cl = '';
}else{
    $hotelian_layout_cl = 'templaza-blog-list uk-child-width-1-1';
    $hotelian_cl = '';
}
$designs    = array(
    array(
        'enable'    => true,
        'class'     => '.templaza-archive-item .uk-card-body',
        'options' => array(
            'blog-page-card-custom',
        ),
    ),
);
if ( class_exists( 'TemPlazaFramework\TemPlazaFramework' ) ) {
    if (count($designs)) {
        $styles = array();

        foreach ($designs as $design) {
            $enable = isset($design['enable']) ? (bool)$design['enable'] : false;
            if ($enable) {
                $wd_css_responsive = array(
                    'desktop' => '',
                    'tablet' => '',
                    'mobile' => '',
                );
                $wd_css = Templates::make_css_design_style($design['options'], $hotelian_options);

                if (!empty($wd_css)) {
                    if (is_array($wd_css)) {
                        foreach ($wd_css as $device => $wd_style) {
                            if (!empty($wd_style)) {
                                $wd_style = $design['class'] . '{' . $wd_style . '}';
                                Templates::add_inline_style($wd_style, $device);
                            }
                        }
                    } else {
                        Templates::add_inline_style($design['class'] . '{' . $wd_css . '}');
                    }
                }
            }
        }
    }
    if ($hotelian_image_cover == true) {
        $hotelian_css = '.templaza-blog-item-img a, .uk-slideshow-items,
     .templaza-blog-item-video .tz-embed-responsive {height: ' . $hotelian_thumbnail_height . 'px;}';

        Templates::add_inline_style($hotelian_css);
    }
}
?>
<div id="templaza-archive-<?php echo esc_attr($hotelian_id);?>" class="templaza-blog templaza-archive templaza-archive-<?php echo esc_attr(get_post_type().$hotelian_custom_class); ?>">
    <div class="templaza-blog-body <?php echo esc_attr($hotelian_layout_cl. ' uk-grid-collapse uk-grid-'.$hotelian_col_gap);?>" data-uk-grid>
        <?php
        $d=1;
        if($wp_query->found_posts==0){
            ?>
            <div class="templaza-blog-item">
                <?php
                do_action('hotelian_archive_no_result');
                ?>
            </div>
            <?php
        }
        if (have_posts()) : while (have_posts()) : the_post();
            $format = get_post_format() ? : 'standard';
            if(is_sticky(get_the_ID())){
                $sticky_cl = 'templaza-sticky';
            }else{
                $sticky_cl = '';
            }
            if($hotelian_leading && $d==1 && $hotelian_layout=='grid'){
                $lead = 'uk-width-1-1';
                $wrap_lead_content = 'templaza-item-lead';
            }else{
                $lead = $wrap_lead_content = ' ';
            }
            if(has_post_thumbnail()){
                $post_thumb_cl = '';
            }else{
                $post_thumb_cl = ' hotelian-no-thumb';
            }
            ?>
            <div id='post-<?php the_ID(); ?>' class="<?php echo esc_attr($hotelian_cl. ' '.$sticky_cl.' '.$lead); ?> templaza-blog-item ">
                <div class="templaza-blog-item-wrap templaza-archive-item uk-position-relative <?php echo esc_attr($wrap_lead_content.$post_thumb_cl);?>">
                    <?php
                    if(is_sticky(get_the_ID()) && has_post_thumbnail()){
                        ?>
                        <span class="templaza-sticky-post" title="<?php echo esc_attr__('Sticky Post','hotelian');?>"><i class="fas fa-thumbtack"></i></span>
                        <?php
                    }
                    if ($hotelian_show_thumbnail){
                        ?>
                        <div class=" uk-postion-relative ">
                            <?php
                            if($format =='standard' || $format=='image'){
                                do_action('hotelian_image_post');
                            }
                            if($format =='gallery'){
                                do_action('hotelian_gallery_post');
                            }
                            if ($format =='video'&& has_post_thumbnail()) {
                                if ($hotelian_show_thumbnail_video){
                                    do_action('hotelian_image_post');
                                }else{
                                    do_action('hotelian_video_post');
                                }
                            }
                            if ($format =='audio' && has_post_thumbnail()){
                                if ($hotelian_show_thumbnail_audio){
                                    do_action('hotelian_image_post');
                                }else{
                                    do_action('hotelian_audio_post');
                                }
                            }
                            if ($format =='link' && has_post_thumbnail()){
                                if ($hotelian_show_thumbnail_link){
                                    do_action('hotelian_image_post');
                                } else {
                                    do_action('hotelian_link_post');
                                }
                            }
                            if ($format == 'quote' && has_post_thumbnail()){
                                if ($hotelian_show_thumbnail_quote){
                                    do_action('hotelian_image_post');
                                } else {
                                    do_action('hotelian_quote_post');
                                }
                            }
                            ?>
                        </div>
                        <?php

                    }
                        ?>
                    <div class="templaza-blog-item-content <?php echo esc_attr($wrap_lead_content);?>">
                        <?php
                        do_action('hotelian_meta_post_header');
                        if ($hotelian_show_title) {
                            do_action('hotelian_title_post');
                        }

                        if ($hotelian_show_description) {
                            do_action('hotelian_excerpt_post');
                        }
                        if($hotelian_show_share || $hotelian_show_readmore){
                            ?>
                            <div class="templaza-archive-share-box uk-flex uk-flex-between uk-flex-middle uk-child-width-1-2@s">
                                <?php
                                if ($hotelian_show_readmore) {
                                    do_action('hotelian_readmore_post');
                                }
                                if ($hotelian_show_share) {
                                    do_action('hotelian_share_post');
                                }
                                ?>
                            </div>
                            <?php
                        }
                        ?>

                    </div>

                </div>
            </div>
            <?php
            $d++;
        endwhile; // end while ( have_posts )

        endif; // end if ( have_posts )
        ?>
    </div>
    <?php if($hotelian_show_pagination){?>
    <div class="templaza-blog-pagenavi">
        <?php
        do_action('hotelian_pagination');
        ?>
    </div>
    <?php } ?>
</div>