<?php

defined('TEMPLAZA_FRAMEWORK');

use TemPlazaFramework\CSS;
use TemPlazaFramework\Functions;
use TemPlazaFramework\Templates;

$hotelian_id             = isset($atts['id'])?$atts['id']:time();
$hotelian_custom_class   = isset($atts['custom-container-class'])?' '.$atts['custom-container-class']:'';
if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' )){
    $hotelian_options = array();
}else{
    $hotelian_options            = Functions::get_theme_options();
}
$hotelian_post_type       = get_post_type(get_the_ID());
$prefix                 = 'blog-single';

$hotelian_show_thumbnail         = isset($hotelian_options[$prefix.'-thumbnail'])?filter_var($hotelian_options[$prefix.'-thumbnail'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_tag               = isset($hotelian_options[$prefix.'-tag'])?filter_var($hotelian_options[$prefix.'-tag'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_meta              = isset($hotelian_options[$prefix.'-meta'])?filter_var($hotelian_options[$prefix.'-meta'], FILTER_VALIDATE_BOOLEAN):false;
$hotelian_show_date              = isset($hotelian_options[$prefix.'-date'])?filter_var($hotelian_options[$prefix.'-date'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_share             = isset($hotelian_options[$prefix.'-share'])?filter_var($hotelian_options[$prefix.'-share'], FILTER_VALIDATE_BOOLEAN):false;
$hotelian_show_title             = isset($hotelian_options[$prefix.'-title'])?filter_var($hotelian_options[$prefix.'-title'], FILTER_VALIDATE_BOOLEAN):false;
$hotelian_show_author            = isset($hotelian_options[$prefix.'-author'])?filter_var($hotelian_options[$prefix.'-author'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_related           = isset($hotelian_options[$prefix.'-related'])?filter_var($hotelian_options[$prefix.'-related'], FILTER_VALIDATE_BOOLEAN):false;
$hotelian_show_comment           = isset($hotelian_options[$prefix.'-comment'])?filter_var($hotelian_options[$prefix.'-comment'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_category          = isset($hotelian_options[$prefix.'-category'])?filter_var($hotelian_options[$prefix.'-category'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_description       = isset($hotelian_options[$prefix.'-description'])?filter_var($hotelian_options[$prefix.'-description'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_comment_count     = isset($hotelian_options[$prefix.'-comment-count'])?filter_var($hotelian_options[$prefix.'-comment-count'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_post_view         = isset($hotelian_options[$prefix.'-post-view'])?filter_var($hotelian_options[$prefix.'-post-view'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_show_post_next_preview = isset($hotelian_options[$prefix.'-next-preview'])?filter_var($hotelian_options[$prefix.'-next-preview'], FILTER_VALIDATE_BOOLEAN):false;

$hotelian_blog_slider_autoplay   = isset($hotelian_options['blog-slider-autoplay'])?filter_var($hotelian_options['blog-slider-autoplay'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_blog_thumbnail_size    = isset($hotelian_options[$prefix.'-thumbnail-size'])?$hotelian_options[$prefix.'-thumbnail-size']:'large';
$hotelian_blog_thumbnail_effect  = isset($hotelian_options[$prefix.'-thumbnail-effect'])?$hotelian_options[$prefix.'-thumbnail-effect']:'none';

$hotelian_blog_slider_animation  = isset($hotelian_options['blog-slider-animation'])?$hotelian_options['blog-slider-animation']:'';
$hotelian_blog_slider_nav        = isset($hotelian_options['blog-slider-nav'])?filter_var($hotelian_options['blog-slider-nav'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_blog_slider_kenburns   = isset($hotelian_options['blog-slider-kenburns'])?filter_var($hotelian_options['blog-slider-kenburns'], FILTER_VALIDATE_BOOLEAN):true;
$show_date          = isset($hotelian_options[$prefix.'-date'])?filter_var($hotelian_options[$prefix.'-date'], FILTER_VALIDATE_BOOLEAN):true;
$hotelian_blog_slider_options = '';
if($hotelian_blog_slider_autoplay == true){
    $hotelian_blog_slider_options .='autoplay: true; ';
}
if($hotelian_blog_slider_animation != ''){
    $hotelian_blog_slider_options .='animation: '.$hotelian_blog_slider_animation. '';
}
if ( have_posts() ) : while (have_posts()) : the_post() ;
    if ( !empty( get_the_content() ) ){
        $tag_class = 'uk-margin-medium-top ';
    }else{
        $tag_class = '';
    }
?>
<div class="templaza-blog">
    <div id="templaza-single-<?php echo esc_attr($hotelian_id); ?>" class="templaza-single templaza-single-<?php
    echo esc_attr($hotelian_post_type.' '.$hotelian_custom_class); ?> templaza-blog-body">
        <?php
            do_action('hotelian_set_postviews',get_the_ID());
            ?>
            <div id="post-<?php the_ID(); ?>" <?php post_class('templaza-blog-item'); ?>>
                <div class="templaza-blog-item-wrap">
                    <div class="templaza-blog-item-content templaza-archive-item ">
                        <div class="templaza-single-content ">
                            <?php
                            if(has_post_thumbnail() || has_post_format('quote') || has_post_format('link')){
                                $post_thumb_cl = '';
                            }else{
                                $post_thumb_cl = 'hotelian-no-thumb';
                            }
                            if ($hotelian_show_thumbnail
                                && (
                                    has_post_format('gallery')  ||
                                    has_post_format('image')  ||
                                    has_post_format('video') ||
                                    has_post_format('audio') ||
                                    has_post_format('link') ||
                                    has_post_format('quote') ||
                                    has_post_format()==false ) ): ?>
                                <div class="templaza-single-feature uk-position-relative <?php echo esc_attr($post_thumb_cl);?>">


                                    <?php
                                    if (has_post_format('gallery')){
                                        do_action('hotelian_gallery_post');
                                    }

                                    if(has_post_thumbnail() && empty(has_post_format('gallery')) && empty(has_post_format('audio'))
                                        && empty(has_post_format('video')) && empty(has_post_format('quote'))&& empty(has_post_format('link'))){
                                        do_action('hotelian_image_post');
                                    }
                                    if (has_post_format('video')){
                                        do_action('hotelian_video_post');
                                    }
                                    if (has_post_format('audio')){
                                        do_action('hotelian_audio_post');
                                    }
                                    if (has_post_format('link')){
                                        do_action('hotelian_link_post');
                                    }
                                    if (has_post_format('quote')) {
                                        do_action('hotelian_quote_post');
                                    }
                                    ?>
                                </div>
                            <?php
                            endif;

                            ?>
                            <div class="templaza-single-description">
                                <?php
                                do_action('hotelian_single_meta_post');
                                $tag_cl = ' ';
                                the_content();
                                wp_link_pages();
                                ?>
                                <div class="clr "></div>

                                <?php
                                if ($hotelian_show_tag && has_tag() && get_the_tag_list() || $hotelian_show_share !=false) {
                                    ?>
                                    <div class="templaza-single-share-box <?php echo esc_attr($tag_cl); ?> uk-flex uk-flex-between uk-flex-middle">
                                    <?php
                                    if ($hotelian_show_tag && has_tag() && get_the_tag_list()){
                                        do_action('hotelian_single_tag_post');
                                    }
                                    if($hotelian_show_share) {
                                        do_action('hotelian_share_post');
                                    }
                                    ?>
                                    </div>
                                    <?php
                                }
                                ?>
                                <?php
                                $post_nav = posts_nav_link();
                                if($hotelian_show_post_next_preview){
                                    ?>
                                    <div class="templaza-single-next-preview templaza-single-box">
                                        <?php
                                        do_action('hotelian_single_next_post');
                                        ?>
                                    </div>
                                    <?php
                                }
                                if($hotelian_show_author && get_the_author_meta('description')){
                                    ?>
                                    <div class="templaza-single-author-box">
                                        <?php
                                        do_action('hotelian_single_author_post');
                                        ?>
                                    </div>
                                    <?php
                                }
                                if($hotelian_show_related){
                                    ?>
                                    <div class="templaza-single-related">
                                        <?php
                                        do_action('hotelian_single_related_post');
                                        ?>
                                    </div>
                                    <?php
                                }
                                if($hotelian_show_comment && comments_open()){
                                    ?>
                                    <div class="templaza-single-comment">
                                        <?php
                                        comments_template( '', true );
                                        ?>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                            </div>
                        </div>

        <?php
        endwhile; // end while ( have_posts )

        ?>
    </div>
</div>
<?php
endif; // end if ( have_posts )