<?php

defined('ADVANCED_PRODUCT') or exit();

use Advanced_Product\AP_Templates;
use Advanced_Product\AP_Functions;
use Advanced_Product\Helper\AP_Product_Helper;

$price = get_field('ap_price', get_the_ID());
$ap_category = wp_get_object_terms( get_the_ID(), 'ap_category', array( 'fields' => 'names' ) );
$compare_layout  = isset($args['compare_layout'])?$args['compare_layout']:'';
if(isset($args['ap_class'])){
    $ap_class = $args['ap_class'];
}else{
    $ap_class = ' templazaFadeInUp';
}
if(isset($_GET['show_icon'])){
    $show_icon = $_GET['show_icon'];
}else {
    $show_icon      = get_field('ap_show_archive_custom_field_icon', 'option');
}
?>
<div class="ap-item ap-item-style2 <?php echo esc_attr($ap_class);?>">
    <div class="ap-inner ">
        <div class="uk-inline uk-position-relative uk-width-1-1">
            <?php
            if( class_exists( 'Comment_Rating_Output' ) ):
                $average_rating = get_post_meta( get_the_ID(), 'tz-average-rating', true );
                if ( empty( $average_rating ) ) {
                    $average_rating = $rating_number =0;
                }else{
                    $rating_number = $average_rating/10;
                    ?>
                <div class="room-rating uk-position-top-left"><i class="fa-regular fa-star"></i>
                    <?php printf( __( '(%d)', 'hotelian' ), $rating_number ); ?>
                </div>
                <?php
                }
            endif;
            ?>
            <?php AP_Templates::load_my_layout('archive.badges'); ?>
            <?php AP_Templates::load_my_layout('archive.media',true,false,array('compare_layout'    => $compare_layout)); ?>
        </div>
        <div class="ap-info">
            <div class="ap-info-inner ap-info-top">
                <h2 class="ap-title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    <?php
                    if($ap_category){
                        echo '<span class="ap-meta">';
                        $field = get_field_object('ap_category');
                        $field_key = $field['key'];
                        $f_icon   = isset($field['icon'])?$field['icon']:'';
                        $f_icon_image   = isset($field['icon_image']) && !empty($field['icon_image'])?$field['icon_image']:'';
                        if((!empty($f_icon['icon']) || !empty($f_icon_image)) && $show_icon){
                            if($f_icon['type'] == 'uikit-icon'){
                                ?>
                                <i data-uk-icon="icon:<?php echo esc_attr($f_icon['icon']); ?>;"></i>
                                <?php
                            }else if((empty($f_icon['type']) || empty($f_icon['icon'])) && !empty($f_icon_image)){
                                echo wp_get_attachment_image($f_icon_image, 'thumbnail', '',
                                    array('data-uk-svg' => '', 'alt' => $field['label']));
                            }elseif(!empty($f_icon['icon'])){
                                ?>
                                <i class="<?php echo esc_attr($f_icon['icon']); ?>"></i>
                                <?php
                            }
                        }
                        foreach ($ap_category as $item){
                            echo esc_html($item);
                        }
                    }
                    echo '</span>';
                    ?>
                </h2>
                <?php AP_Templates::load_my_layout('archive.price');?>
            </div>
            <div class="ap-info-inner  ap-info-bottom">
                <?php AP_Templates::load_my_layout('archive.custom-fields-style2'); ?>
                <div class="ap-readmore-box">
                    <a href="<?php the_permalink(); ?>" class="templaza-btn"><?php esc_html_e('Book Now','hotelian');?></a>
                    <img data-uk-svg src="<?php echo esc_url(get_template_directory_uri().'/assets/images/aright-room.svg'); ?>">
                </div>
            </div>
        </div>
    </div>
</div>
<?php