<?php

defined('ADVANCED_PRODUCT') or exit();

use Advanced_Product\AP_Functions;
use Advanced_Product\Helper\AP_Helper;
use Advanced_Product\Helper\AP_Custom_Field_Helper;
use TemPlazaFramework\Functions;
?>
<?php
if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' )){
    $hotelian_options = array();
}else{
    $hotelian_options = Functions::get_theme_options();
}
if(isset($args['product_id'])){
    $product_id = $args['product_id'];
}else{
	$product_id = get_the_ID();
}
$sold_text     = isset($hotelian_options['ap_product-sold-label'])?$hotelian_options['ap_product-sold-label']:'';
$contact_text     = isset($hotelian_options['ap_product-contact-label'])?$hotelian_options['ap_product-contact-label']:'';
$msrp           = get_field('ap_price_msrp', $product_id);
$price          = get_field('ap_price', $product_id);
$rental         = get_field('ap_rental_price', $product_id);
$rental_value    = get_field('ap_rental_unit', $product_id);
if($rental_value){
    $field_rental = get_field_object('ap_rental_unit',$product_id);
    $rental_unit = $field_rental['choices'][ $rental_value ];
}

$price_contact  = get_field('ap_price_contact', $product_id);
$product_type   = get_field('ap_product_type', $product_id);
$price_notice_value = get_field('price-notice', $product_id);
$price_sold = get_field('ap_price_sold', $product_id);
$price_contact = get_field('ap_price_contact', $product_id);

$show_price         = AP_Custom_Field_Helper::get_field_display_flag_by_field_name('show_in_listing', 'ap_price');
$show_price_msrp    = AP_Custom_Field_Helper::get_field_display_flag_by_field_name('show_in_listing', 'ap_price_msrp');
$show_price_notice  = AP_Custom_Field_Helper::get_field_display_flag('show_in_listing', 'price-notice');
$show_price_rental  = AP_Custom_Field_Helper::get_field_display_flag_by_field_name('show_in_listing', 'ap_rental_price');
$show_price_contact  = AP_Custom_Field_Helper::get_field_display_flag_by_field_name('show_in_listing', 'ap_price_contact');
$show_price_sold  = AP_Custom_Field_Helper::get_field_display_flag_by_field_name('show_in_listing', 'ap_price_sold');
if($product_type == 'sale'){
    $product_type = array('sale');
}
if($price_sold == ''){
    $price_sold = $sold_text;
}
if($price_contact == ''){
    $price_contact = $contact_text;
}
if(isset($_GET['product_loop'])){
    $ap_loop_layout = sanitize_text_field($_GET['product_loop']);
}else {
    $ap_loop_layout = isset($hotelian_options['ap_product-loop-layout']) ? $hotelian_options['ap_product-loop-layout'] : 'style1';
}
$f_value            = get_field('unit-price', $product_id);
if ((!$product_type || in_array('sale', $product_type)) && !empty($price) && $show_price) {
    ?>
    <div class="ap-price-box">
        <span class="ap-field-label"><?php esc_html_e('From','hotelian')?></span>
        <?php
        $html = sprintf('<span class="ap-price"><b> %s</b> %s </span>',
            esc_html__(' ', 'hotelian'), AP_Helper::format_price($price));
        if (!empty($msrp) && $show_price_msrp) {
            $html .= sprintf('<span class="ap-price-msrp"><span> %s </span>  %s </span>',
                esc_html__('MSRP: ', 'hotelian'), AP_Helper::format_price($msrp));
        }
        echo wp_kses($html,'post');
        if(!empty($price_notice_value) && $show_price_notice){
        ?>
        <span class="meta">
            <?php echo esc_html($price_notice_value);?>
        </span>
        <?php } ?>
    </div>
<?php }

if ((!empty($product_type) && in_array('contact', $product_type)) && !empty($price_contact) && $show_price_contact) {
    ?>
    <div class="ap-price-box">
        <span class="ap-field-label"><?php esc_html_e('Price','hotelian')?></span>
        <span class="ap-price">
            <?php echo esc_html($price_contact);?>
        </span>
    </div>
<?php }

if ((!empty($product_type) && in_array('sold', $product_type)) && !empty($price_sold) && $show_price_sold) {
    ?>
    <div class="ap-price-box">
        <span class="ap-field-label"><?php esc_html_e('Status','hotelian')?></span>
        <span class="ap-price">
            <?php echo esc_html($price_sold);?>
        </span>
    </div>
<?php }

if (!empty($product_type) && in_array('rental', $product_type) && !empty($rental) && $show_price_rental) { ?>
    <div class="ap-price-box">
        <span class="ap-field-label"><?php esc_html_e('Rental price','hotelian')?></span>
        <?php
        if($ap_loop_layout == 'style7'){
            echo '<div class="ap-price-value-wrap">';
        }
        ?>
        <span class="ap-price ap-price-rental uk-display-inline-block">
            <?php
            echo esc_html(AP_Helper::format_price($rental));
            if(!empty($rental_unit)){ ?>
                <span class="meta ap-unit">
                    <?php esc_html_e(' / ','hotelian'); echo esc_html($rental_unit);?>
                </span>
            <?php }
            ?>
        </span>
        <?php
        if($ap_loop_layout == 'style7'){
            echo '</div>';
        }
        ?>
    </div>
<?php } ?>
