<?php
use TemPlazaFramework\Functions;
use Advanced_Product\Helper\AP_Helper;
if ( ! class_exists( 'Hotelian_Handler' ) ) {
	/**
	 * Main theme class with configuration
	 */
	class Hotelian_Handler {
		private static $instance;

		public function __construct() {
			require_once get_template_directory() . '/helpers/helper.php';
			require_once get_template_directory() . '/helpers/theme-functions.php';
            require_once get_template_directory() . '/helpers/woocommerce/woocommerce-load.php';
			require_once get_template_directory() . '/plugins/class-tgm-plugin-activation.php';
            require_once get_template_directory() . '/helpers/data-install.php';
            require_once get_template_directory() . '/helpers/theme-color.php';
            if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' )){
                $templaza_options = array();
            }else{
                $templaza_options = Functions::get_theme_options();
            }
            $ap_booking  = isset($templaza_options['ap_product-booking-enable'])?$templaza_options['ap_product-booking-enable']:false;
            if($ap_booking){
                require get_template_directory() . '/booking/booking.php';
            }
			add_action( 'after_setup_theme', array( $this, 'hotelian_setup' ) );
			add_action( 'widgets_init', array( $this, 'hotelian_sidebar_registration' ) );
			add_action( 'init', array( $this, 'hotelian_register_theme_scripts' ) );
			add_action( 'init', array( $this, 'hotelian_pattern_categories' ) );
			add_filter( 'widget_title', 'do_shortcode' );
			add_filter( 'wp_nav_menu_items', 'do_shortcode' );
            add_filter('wp_img_tag_add_auto_sizes', '__return_false');
			add_action( 'comment_form_before', array( $this, 'hotelian_enqueue_comments_reply' ) );
			add_filter( 'the_password_form', array( $this, 'hotelian_password_form' ), 10, 2 );
			add_action( 'tgmpa_register', array ( $this, 'hotelian_register_required_plugins' ) );
            add_filter( 'excerpt_more', array ( $this, 'hotelian_continue_reading_link_excerpt' ) );
            add_filter( 'the_content_more_link', array( $this, 'hotelian_continue_reading_link' ) );
			add_action( 'pre_get_posts', array($this,'hotelian_set_posts_per_page_post_type') );
            add_filter('templaza-elements/settings-post-type', array($this, 'hotelian_add_post_type'));
			get_template_part( 'inc/block-styles' );
			if ( class_exists( 'TemPlazaFramework\TemPlazaFramework' ) ) {
				if (is_admin()) {
					add_action('admin_enqueue_scripts', array($this,'hotelian_register_back_end_scripts'));
				}
			}

			if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' ) || !class_exists( 'Redux_Framework_Plugin' ) ) {
				add_action( 'after_setup_theme', array( $this, 'hotelian_basic_setup' ) );
				add_action( 'init', array( $this, 'hotelian_basic_register_theme_scripts' ) );
			}

		}

		/**
		 * @return Hotelian_Handler
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
		function hotelian_register_back_end_scripts(){
            wp_enqueue_style(TEMPLAZA_FRAMEWORK_NAME.'__css');
        }

        function hotelian_setup() {
			load_theme_textdomain('hotelian', get_template_directory() . '/languages');
			add_theme_support( 'templaza-framework' );
            add_theme_support('templaza-post-type', array('service','restaurant','our_team'));
			add_theme_support('post-formats', array('gallery', 'video', 'audio', 'link', 'quote'));
			add_theme_support('post-thumbnails');
			add_theme_support( 'title-tag' );
			add_theme_support( 'automatic-feed-links' );
            add_theme_support( 'woocommerce' );
			add_theme_support(
			    'html5',
                array(
				    'script',
	                'style',
	                'comment-list',
                )
            );

            add_theme_support(
                'editor-font-sizes',
                array(
                    array(
                        'name'      => esc_html__( 'Small', 'hotelian' ),
                        'shortName' => esc_html_x( 'S', 'Font size', 'hotelian' ),
                        'size'      => 14,
                        'slug'      => 'small',
                    ),
                    array(
                        'name'      => esc_html__( 'Normal', 'hotelian' ),
                        'shortName' => esc_html_x( 'M', 'Font size', 'hotelian' ),
                        'size'      => 16,
                        'slug'      => 'normal',
                    ),
                    array(
                        'name'      => esc_html__( 'Large', 'hotelian' ),
                        'shortName' => esc_html_x( 'L', 'Font size', 'hotelian' ),
                        'size'      => 24,
                        'slug'      => 'large',
                    ),
                    array(
                        'name'      => esc_html__( 'Extra large', 'hotelian' ),
                        'shortName' => esc_html_x( 'XL', 'Font size', 'hotelian' ),
                        'size'      => 40,
                        'slug'      => 'extra-large',
                    ),
                )
            );


			// Add theme support for selective refresh for widgets.
			add_theme_support( 'customize-selective-refresh-widgets' );
			// Add support for responsive embedded content.
			add_theme_support( 'responsive-embeds' );

			// Add support for custom line height controls.
			add_theme_support( 'custom-line-height' );

			// Add support for experimental link color control.
			add_theme_support( 'experimental-link-color' );

			// Add support for experimental cover block spacing.
			add_theme_support( 'custom-spacing' );
			add_theme_support( 'widgets-block-editor' );

			// Add support for custom units.
			// This was removed in WordPress 5.6 but is still required to properly support WP 5.5.
			add_theme_support( 'custom-units' );

			add_theme_support( 'wp-block-styles' );
			add_theme_support( 'editor-styles' );
			add_editor_style( array( 'assets/css/style-editor.css', hotelian_basic_fonts_url()) );
		}
        function hotelian_add_post_type( $post_type ) {
            return array_merge( $post_type, array(
                'service' => esc_html__('Services', 'hotelian'),
                'restaurant' => esc_html__('Restaurant', 'hotelian'),
                'our_team' => esc_html__('Our Team', 'hotelian')
            ));
        }
		function hotelian_sidebar_registration() {
			register_sidebar(
				array(
					'name'        => esc_html__( 'Main Sidebar', 'hotelian' ),
					'id'          => 'sidebar-main',
					'description' => esc_html__( 'Widgets in this area will be displayed in the TemPlaza Framework layout builder sidebar only.', 'hotelian' ),
				)
			);
			register_sidebar(
				array(
					'name'        => esc_html__( 'Shop Sidebar', 'hotelian' ),
					'id'          => 'sidebar-shop',
					'description' => esc_html__( 'Widgets in this area will be displayed in the Shop page.', 'hotelian' ),
				)
			);
			register_sidebar(
				array(
					'name'        => esc_html__( 'Top Sidebar', 'hotelian' ),
					'id'          => 'sidebar-top',
					'description' => esc_html__( 'Widgets in this area will be displayed in the first column in the top sidebar.', 'hotelian' ),
				)
			);
			register_sidebar(
				array(
					'name'        => esc_html__( 'Inventory Sidebar', 'hotelian' ),
					'id'          => 'sidebar-inventory',
					'description' => esc_html__( 'Widgets in this area will be displayed in Inventory sidebar.', 'hotelian' ),
				)
			);
			register_sidebar(
				array(
					'name'        => esc_html__( 'Inventory Top Sidebar', 'hotelian' ),
					'id'          => 'sidebar-inventory-top',
					'description' => esc_html__( 'Widgets in this area will be displayed in Inventory sidebar.', 'hotelian' ),
				)
			);
			register_sidebar(
				array(
					'name'        => esc_html__( 'Nearby Logo', 'hotelian' ),
					'id'          => 'sidebar-nearby-logo',
					'description' => esc_html__( 'Widgets in this area will be displayed in logo section.', 'hotelian' ),
				)
			);
			register_sidebar(
				array(
					'name'        => esc_html__( 'Nearby Menu', 'hotelian' ),
					'id'          => 'sidebar-nearby-menu',
					'description' => esc_html__( 'Widgets in this area will be displayed in menu section.', 'hotelian' ),
				)
			);
			register_sidebar(
				array(
					'name'        => esc_html__( 'Left Sidebar', 'hotelian' ),
					'id'          => 'sidebar-left',
					'description' => esc_html__( 'Widgets in this area will be displayed in left sidebar.', 'hotelian' ),
				)
			);

			register_sidebar(
				array(
					'name'        => esc_html__( 'Header Sidebar Mode', 'hotelian' ),
					'id'          => 'sidebar-mode',
					'description' => esc_html__( 'Widgets in this area will be displayed in the first column in the Sidebar - Header Mode of TemPlaza Framework only.', 'hotelian' ),
				)
			);
		}

		function hotelian_register_front_end_styles()
		{
			if(!is_child_theme()){
				wp_enqueue_style('hotelian-style', get_template_directory_uri() . '/style.css', false );
			}
            wp_dequeue_style( 'wp-block-library-theme' );
            wp_register_style('hotelian-tiny-slider-style', get_template_directory_uri() . '/assets/css/tiny-slider.css', false );
            wp_enqueue_style('hotelian-animation-style', get_template_directory_uri() . '/assets/css/animation.css', array(),time() );
		}

		function hotelian_register_front_end_scripts()
		{

			wp_register_script('hotelian-tiny-slider-script', get_template_directory_uri() . '/assets/js/tiny-slider.js', array(), false, $in_footer = true);
            wp_enqueue_script('hotelian-animation-script', get_template_directory_uri() . '/assets/js/animation2.js', array('gsap-SplitText'), time(), $in_footer = true);


            $admin_url = admin_url('admin-ajax.php');
            $hotelian_ajax_url = array('url' => $admin_url);
			wp_register_script( 'hotelian-scripts', get_template_directory_uri() . '/assets/js/scripts.js', array('jquery'),time() );
			wp_enqueue_script( 'hotelian-scripts' );

            wp_enqueue_script('uidecorativebackground-perlin');
            wp_enqueue_script_module('uidecorativebackground-index');

            if(!class_exists( 'TemPlazaFramework\TemPlazaFramework' ) && class_exists( 'woocommerce' )) {
                wp_register_script('hotelian-tz-woo-notify', get_template_directory_uri() . '/assets/js/woo/notify.min.js', array(), '1.0.0', true);
                wp_register_script('hotelian-tz-woo-swiper', get_template_directory_uri() . '/assets/js/woo/swiper.min.js', array('jquery'), '5.3.8', true);

                wp_register_script('hotelian-tz-woo-viewport', get_template_directory_uri() . '/assets/js/woo/isInViewport.min.js', array('jquery'), false, true);
                wp_enqueue_script('hotelian-tz-woo-viewport');
                wp_register_script('hotelian-tz-woo-catalog', get_template_directory_uri() . '/assets/js/woo/woo-catalog.js', array('jquery'), false, true);
                wp_enqueue_script('hotelian-tz-woo-catalog');

                wp_enqueue_script('hotelian-tz-woo-scripts', get_template_directory_uri() . '/assets/js/woo/woo-scripts.js', array(
                    'jquery',
                    'hotelian-tz-woo-viewport',
                    'hotelian-tz-woo-swiper',
                    'hotelian-tz-woo-notify',
                    'imagesloaded',
                ), false, true);

                $hotelian_tz_data = array(
                    'direction' => is_rtl() ? 'true' : 'false',
                    'ajax_url' => class_exists('WC_AJAX') ? \WC_AJAX::get_endpoint('%%endpoint%%') : '',
                    'nonce' => wp_create_nonce('_hotelian_tz_nonce'),
                    'search_content_type' => get_option('header_search_type'),
                    'header_search_number' => get_option('header_search_number'),
                    'header_ajax_search' => intval(get_option('header_search_ajax')),
                    'sticky_header' => intval(get_option('header_sticky')),
                    'mobile_landscape' => get_option('mobile_landscape_product_columns'),
                    'mobile_portrait' => get_option('mobile_portrait_product_columns'),
                    'popup' => get_option('newsletter_popup_enable'),
                    'popup_frequency' => get_option('newsletter_popup_frequency'),
                    'popup_visible' => get_option('newsletter_popup_visible'),
                    'popup_visible_delay' => get_option('newsletter_popup_visible_delay'),
                );

                $hotelian_tz_data = apply_filters('hotelian_tz_wp_script_data', $hotelian_tz_data);
                wp_localize_script(
                    'hotelian-tz-woo-scripts', 'hotelianTzData', $hotelian_tz_data
                );
            }

			wp_localize_script('hotelian-scripts', 'hotelian_ajax_url', $hotelian_ajax_url);

        }

        function hotelian_register_theme_scripts()
        {
            if ($GLOBALS['pagenow'] != 'wp-login.php') {
                if ( !is_admin() ) {
                    add_action('wp_enqueue_scripts', array( $this, 'hotelian_register_front_end_styles' ) );
                    add_action('wp_enqueue_scripts', array( $this, 'hotelian_register_front_end_scripts') );
                }
            }
        }
        function hotelian_pattern_categories() {

            register_block_pattern_category(
                'hotelian_page',
                array(
                    'label'       => _x( 'Pages', 'Block pattern category', 'hotelian' ),
                    'description' => __( 'A collection of full page layouts.', 'hotelian' ),
                )
            );
        }

        function hotelian_enqueue_comments_reply() {
            if( get_option( 'thread_comments' ) ) {
                wp_enqueue_script( 'comment-reply' );
            }
        }

        function hotelian_password_form( $output, $post = 0 ) {
            $post   = get_post( $post );
            $label  = 'pwbox-' . ( empty( $post->ID ) ? wp_rand() : $post->ID );
            $output = '<p class="post-password-message">' . esc_html__( 'This content is password protected. Please enter a password to view.', 'hotelian' ) . '</p>
    <p class="pass_label"> <label class="post-password-form__label" for="' . esc_attr( $label ) . '">' . esc_html_x( 'Password', 'Post password form', 'hotelian' ) . '</label></p>
    <form action="' . esc_url( home_url( 'wp-login.php?action=postpass', 'login_post' ) ) . '" class="post-password-form" method="post">
    <input class="post-password-form__input" name="post_password" id="' . esc_attr( $label ) . '" type="password" size="20" />
    <input type="submit" class="post-password-form__submit" name="' . esc_attr_x( 'Submit', 'Post password form', 'hotelian' ) . '" value="' . esc_attr_x( 'Enter', 'Post password form', 'hotelian' ) . '" /></form>
    ';
            return $output;
        }

        function hotelian_register_required_plugins()
        {
            /**
             * Array of plugin arrays. Required keys are name and slug.
             * If the source is NOT from the .org repo, then source is also required.
             */
			$hotelian_plugins = array(

				// This is an example of how to include a plugin pre-packaged with a theme
                array(
                    'name' => esc_html__('TemPlaza Framework', 'hotelian'), /* The plugin name */
                    'slug' => 'templaza-framework', /* The plugin slug (typically the folder name) */
                    'source' => 'https://github.com/templaza/templaza-framework/releases/latest/download/templaza-framework.zip', /* The plugin source */
                    'required' => true, /* If false, the plugin is only 'recommended' instead of required */
                    'version' => '1.3.5', /* E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented */
                    'force_activation' => false, /* If true, plugin is activated upon theme activation and cannot be deactivated until theme switch */
                    'force_deactivation' => false, /* If true, plugin is deactivated upon theme switch, useful for theme-specific plugins */
                    'external_url' => '', /* If set, overrides default API URL and points to an external URL */
                ),
                array(
                    'name' => esc_html__('UiPro', 'hotelian'), /* The plugin name */
                    'slug' => 'uipro', /* The plugin slug (typically the folder name) */
                    'source' => 'https://github.com/templaza/uipro/releases/latest/download/uipro.zip', /* The plugin source */
                    'required' => true, /* If false, the plugin is only 'recommended' instead of required */
                    'version' => '1.1.4', /* E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented */
                    'force_activation' => false, /* If true, plugin is activated upon theme activation and cannot be deactivated until theme switch */
                    'force_deactivation' => false, /* If true, plugin is deactivated upon theme switch, useful for theme-specific plugins */
                    'external_url' => '', /* If set, overrides default API URL and points to an external URL */
                ),
                array(
                    'name' => esc_html__('Advanced Product', 'hotelian'), /* The plugin name */
                    'slug' => 'advanced-product', /* The plugin slug (typically the folder name) */
                    'source' => 'https://github.com/templaza/advanced-product/releases/latest/download/advanced-product.zip', /* The plugin source */
                    'required' => true, /* If false, the plugin is only 'recommended' instead of required */
                    'version' => '1.1.9', /* E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented */
                    'force_activation' => false, /* If true, plugin is activated upon theme activation and cannot be deactivated until theme switch */
                    'force_deactivation' => false, /* If true, plugin is deactivated upon theme switch, useful for theme-specific plugins */
                    'external_url' => '', /* If set, overrides default API URL and points to an external URL */
                ),
                array(
                    'name'     				=> esc_html__('Slider Revolution','hotelian'), // The plugin name
                    'slug'     				=> 'revslider', // The plugin slug (typically the folder name)
                    'source'   				=> 'https://wptheme.co/sources/revslider.zip?t='.time(), // The plugin source
                    'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
                    'version' 				=> '6.7.36', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
                    'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
                    'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
                    'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
                ),
                array(
                    'name' => esc_html__('Redux Framework', 'hotelian'), /* The plugin name */
                    'slug' => 'redux-framework', /* The plugin slug (typically the folder name) */
                    'required' => true,
                ),
                array(
                    'name' => ' Elementor Website Builder',
                    'slug' => 'elementor',
                    'required' => true,
                ),
                array(
                    'name' => 'WP Shortcodes Plugin',
                    'slug' => 'shortcodes-ultimate',
                    'required' => true,
                ),
                array(
                    'name' => 'WooCommerce',
                    'slug' => 'woocommerce',
                    'required' => true,
                ),
                array(
                    'name' => 'WCBoost – Variation Swatches',
                    'slug' => 'wcboost-variation-swatches',
                    'required' => true,
                ),
                array(
                    'name' => 'YITH WooCommerce Wishlist',
                    'slug' => 'yith-woocommerce-wishlist',
                    'required' => true,
                ),
                array(
                    'name' => 'Contact Form by WPForms',
                    'slug' => 'wpforms-lite',
                    'required' => true,
                ),
			);

			/**
			 * Array of configuration settings. Amend each line as needed.
			 * If you want the default strings to be available under your own theme domain,
			 * leave the strings uncommented.
			 * Some of the strings are added into a sprintf, so see the comments at the
			 * end of each line for what each argument will be.
			 */

			$hotelian_config = array(
				'id' => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
				'default_path' => '',                      // Default absolute path to bundled plugins.
				'menu' => 'tgmpa-install-plugins', // Menu slug.
				'parent_slug' => 'themes.php',            // Parent menu slug.
				'capability' => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
				'has_notices' => true,                    // Show admin notices or not.
				'dismissable' => true,                    // If false, a user cannot dismiss the nag message.
				'dismiss_msg' => '',                      // If 'dismissable' is false, this message will be output at top of nag.
				'is_automatic' => true,                   // Automatically activate plugins after installation or not.
				'message' => '',                      // Message to output right before the plugins table.
			);

			tgmpa($hotelian_plugins, $hotelian_config);
		}

		function hotelian_basic_setup(){
			register_nav_menus(
				array(
					'primary' => esc_html__( 'Primary menu', 'hotelian' ),
				)
			);
			$logo_width  = 115;
			$logo_height = 45;
			add_theme_support(
				'custom-logo',
				array(
					'height'               => $logo_height,
					'width'                => $logo_width,
					'flex-width'           => true,
					'flex-height'          => true,
					'unlink-homepage-logo' => true,
				)
			);
            $args = array(
                'width'         => 1920,
                'height'        => 400,
                'uploads'       => true,
            );
            add_theme_support( 'custom-header', $args );
            add_theme_support( 'custom-background' );
            add_theme_support( 'align-wide' );
		}


		function hotelian_basic_register_front_end_styles()
		{
            $theme          = wp_get_theme();
			wp_enqueue_style( 'hotelian-basic-fonts', hotelian_basic_fonts_url(), array(), null );
			wp_enqueue_style('hotelian-basic-style-min', get_template_directory_uri() . '/assets/css/style.min.css',array(), $theme->get('Version').time() );
			wp_enqueue_style('hotelian-basic-fontawesome', get_template_directory_uri() . '/assets/css/fontawesome/css/all.min.css', false );

		}

		function hotelian_basic_register_front_end_scripts()
		{
			wp_enqueue_script('hotelian-basic-script-uikit', get_template_directory_uri() . '/assets/js/uikit.min.js', false );
			wp_enqueue_script('hotelian-basic-script-uikit-icon', get_template_directory_uri() . '/assets/js/uikit-icons.min.js', false );
			wp_enqueue_script('hotelian-basic-script-basic', get_template_directory_uri() . '/assets/js/basic.js', array('jquery') );
		}

		function hotelian_basic_register_theme_scripts()
		{
			if ($GLOBALS['pagenow'] != 'wp-login.php') {
				if ( !is_admin() )  {
					add_action('wp_enqueue_scripts', array( $this, 'hotelian_basic_register_front_end_styles' ) );
					add_action('wp_enqueue_scripts', array( $this, 'hotelian_basic_register_front_end_scripts' ) );
				}
			}
		}

		function hotelian_continue_reading_link_excerpt() {
			if ( ! is_admin() ) {
				return '&hellip; <a class="more-link" href="' . esc_url( get_permalink() ) . '">' . hotelian_basic_continue_reading_text() . '</a>';
			}
			return '';
		}

		function hotelian_continue_reading_link() {
			if ( ! is_admin() ) {
				return '<div class="more-link-container"><a class="more-link" href="' . esc_url( get_permalink() ) . '#more-' . esc_attr( get_the_ID() ) . '">' . hotelian_basic_continue_reading_text() . '</a></div>';
			}
			return '';
		}
		function hotelian_set_posts_per_page_post_type( $query ) {
			if ( !is_admin() && $query->is_main_query() && class_exists( 'Advanced_Product\Advanced_Product' )) {
				if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' )){
					$templaza_options = array();
				}else{
					$templaza_options = Functions::get_theme_options();
				}
				if(is_post_type_archive( 'ap_product' ) || is_tax( 'ap_category' ) || is_tax( get_query_var('taxonomy') ) || is_tax( 'ap_branch' ) || AP_Helper::is_inventory()){
					if(isset($_GET['product_limit'])){
						$ap_per_page = $_GET['product_limit'];
					}else{
						$ap_per_page       = isset($templaza_options['ap_product-products_per_page'])?$templaza_options['ap_product-products_per_page']:9;
					}
					$query->set( 'posts_per_page', ''.$ap_per_page.'' );
					$ap_sold       = isset($templaza_options['ap_product-archive-product-sold'])?$templaza_options['ap_product-archive-product-sold']:false;
					if($ap_sold == true) {
						$meta_query_old = $query->get('meta_query');
						$meta_query_new = array();
						if (is_array($meta_query_old)) {
							foreach ($meta_query_old as $meta_query) {
								$meta_query_new = $meta_query;
							}
						}
						$custom_query = array(
							'relation' => 'AND',
							array(
								'relation' => 'OR',
								array(
									'key' => 'ap_product_type',
									'value' => 'sold',
									'compare' => 'NOT LIKE',
								),
								array(
									'key' => 'ap_product_type',
									'compare' => 'NOT EXISTS',
								),
							),
							$meta_query_new
						);

						$query->set('meta_query', $custom_query);
					}
					return $query;
				}
				if(is_post_type_archive( 'our_team' ) || is_tax( 'our_team-category') || is_tax( 'our_team_tag' ) ){

					$query->set( 'posts_per_page', 6 );

				}
			}
		}

	}
	Hotelian_Handler::get_instance();
}