<?php
defined('TEMPLAZA_FRAMEWORK') or exit();
use TemPlazaFramework\Functions;
use Advanced_Product\Helper\AP_Custom_Field_Helper;

$Field_Helper = new AP_Custom_Field_Helper();

$type_exists = method_exists($Field_Helper, 'get_acf_fields_by_type');
if($type_exists){
    $number_fields = AP_Custom_Field_Helper::get_acf_fields_by_type(array('number'));
}else{
    $number_fields = array();
}

$price_arr = array();
if(!empty($number_fields)){
    foreach($number_fields as $i =>$field){
        $price_arr[$i] = $field;
    }
}
$arr_wpform = array();
if(function_exists('wpforms')){
    $args = array(
        'numberposts' => -1,
        'post_type'   => 'wpforms'
    );

    $wpforms = get_posts( $args );
    if ( $wpforms && !is_wp_error($wpforms) ) {
        foreach ( $wpforms as $post ){
            $arr_wpform[$post->ID] = $post->post_title;
        }
        wp_reset_postdata();
    }
}
$arr_wpform['custom'] = esc_html__('Custom','hotelian');


Templaza_API::add_field_arguments('settings', 'blog-page',
    array(
        'blog-page-layout' => array(
            'options' => array(
                'columns' => 'Columns',
                'list' => 'List',
                'grid' => 'Grid',
            )
        ),
    )
);
Templaza_API::set_fields('settings', 'blog-page',
    array(
        array(
            'id'       => 'blog-page-column-gap',
            'type'     => 'select',
            'title'    => esc_html__('Column Gap', 'hotelian'),
            'subtitle' => esc_html__('Column Gap grid.', 'hotelian'),
            'options'  => array(
                'default' => esc_html__('Default','hotelian'),
                'small' => esc_html__('Small','hotelian'),
                'medium' => esc_html__('Medium','hotelian'),
                'large' => esc_html__('Large','hotelian'),
                'collapse' => esc_html__('Collapse','hotelian'),
            ),
            'default'  => 'default',
            'required' => array('blog-page-layout', '=' , array('grid','columns'))
        ),
        array(
            'id'       => 'blog-page-card-size',
            'type'     => 'select',
            'title'    => esc_html__('Card Size', 'hotelian'),
            'options'  => array(
                'default' => esc_html__('Default','hotelian'),
                'small' => esc_html__('Small','hotelian'),
                'large' => esc_html__('Large','hotelian'),
                'custom' => esc_html__('Custom','hotelian'),
            ),
            'default'  => 'default',
            'required' => array('blog-page-layout', '=' , 'grid')
        ),
        array(
            'id'       => 'blog-page-card-custom',
            'type'     => 'spacing',
            'allow_responsive'    => true,
            'title'    => esc_html__('Card custom', 'hotelian'),
            'default'  => '',
            'required' => array('blog-page-card-size', '=' , 'custom')
        ),
        array(
            'id'       => 'blog-page-image-cover',
            'type'     => 'switch',
            'title'    => esc_html__( 'Cover image', 'hotelian' ),
            'default'  => true,
        ),
        array(
            'id'       => 'blog-page-thumbnail-height',
            'type'     => 'spinner',
            'title'    => esc_html__('Thumbnail height', 'hotelian'),
            'default'  => '300',
            'min'      => '100',
            'step'     => '1',
            'max'      => '1000',
            'required' => array('blog-page-image-cover', '=' , true)
        ),
    )
);

Templaza_API::set_subsection('settings', 'colors',
    array(
        'title'      => esc_html__( 'Theme Color', 'hotelian' ),
        'id'         => 'colors-theme-color',
        'desc'       => esc_html__( 'Select colors for theme', 'hotelian' ),
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'theme-color',
                'type'     => 'color_rgba',
                'title'    => esc_html__( 'Theme color', 'hotelian' ),
                'subtitle' => esc_html__( 'Set the color of theme', 'hotelian' ),
            ),
        ),
    )
);

Templaza_API::set_subsection('settings', 'advanced-products-options',
    array(
        'title'      => esc_html__( 'Payment Options', 'hotelian' ),
        'id'         => 'ap_product-booking',
        'desc'       => esc_html__( 'Options for booking form and payment', 'hotelian' ),
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'ap_product-booking-enable',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Booking', 'hotelian' ),
                'default'  => true,
            ),
            array(
                'id'       => 'ap_product-booking-page-functions',
                'type'     => 'section',
                'title'    => esc_html__( 'Choose Page functions', 'hotelian' ),
                'indent'  => true,
                'required' => array('ap_product-booking-enable', '=' , true)
            ),
            array(
                'id' => 'ap_product_cart_page',
                'type' => 'select',
                'title' => esc_html__('Tour Cart Page', 'hotelian'),
                'subtitle' => esc_html__('This sets the base page of your tour booking. Please add [tz_booking_cart] shortcode in the page content.', 'hotelian'),
                'data' => 'pages',
                'args' => array(
                    'sort_order' => esc_html__('asc', 'hotelian'),
                    'sort_column' => esc_html__('post_title', 'hotelian'),
                ),
            ),
            array(
                'id' => 'ap_product_checkout_page',
                'type' => 'select',
                'title' => esc_html__('Tour Checkout Page', 'hotelian'),
                'subtitle' => esc_html__('This sets the tour Checkout Page. Please add [tz_booking_checkout] shortcode in the page content.', 'hotelian'),
                'data' => 'pages',
                'args' => array(
                    'sort_order' => esc_html__('asc', 'hotelian'),
                    'sort_column' => esc_html__('post_title', 'hotelian'),
                ),
            ),
            array(
                'id' => 'ap_product_confirm_page',
                'type' => 'select',
                'title' => esc_html__('Tour Booking Confirmation Page', 'hotelian'),
                'subtitle' => esc_html__('This sets the tour booking confirmation Page. Please add [tz_booking_confirm] shortcode in the page content.', 'hotelian'),
                'data' => 'pages',
                'args' => array(
                    'sort_order' => esc_html__('asc', 'hotelian'),
                    'sort_column' => esc_html__('post_title', 'hotelian'),
                ),
            ),
            array(
                'id'       => 'ap_product-booking-data',
                'type'     => 'section',
                'title'    => esc_html__( 'Config Data', 'hotelian' ),
                'indent'  => true,
                'required' => array('ap_product-booking-enable', '=' , true)
            ),
            array(
                'id' => 'ap_product_data_price',
                'type' => 'select',
                'title' => esc_html__('Select Field adult Price', 'hotelian'),
                'subtitle' => esc_html__('Select field (type number) to calculator price.', 'hotelian'),
                'options'  => $price_arr,
            ),
            array(
                'id' => 'ap_product_data_child_price',
                'type' => 'select',
                'title' => esc_html__('Select Field Child Price', 'hotelian'),
                'subtitle' => esc_html__('Select field (type number) to calculator child price.', 'hotelian'),
                'options'  => $price_arr,
            ),
            array(
                'id'       => 'ap_product-booking-payment',
                'type'     => 'section',
                'title'    => esc_html__( 'Config Payment', 'hotelian' ),
                'indent'  => true,
                'required' => array('ap_product-booking-enable', '=' , true)
            ),
            array(
                'id'       => 'ap_product_payment_cash',
                'type'     => 'switch',
                'title'    => esc_html__( 'Payment In Cash', 'hotelian' ),
                'default'  => true,
            ),
            array(
                'id'       => 'ap_product_payment_paypal',
                'type'     => 'switch',
                'title'    => esc_html__( 'PayPal Integration ', 'hotelian' ),
                'subtitle'    => esc_html__( 'Enable payment through PayPal in booking step. ', 'hotelian' ),
                'default'  => true,
            ),
            array(
                'id'       => 'ap_product_payment_paypal_card',
                'type'     => 'switch',
                'title'    => esc_html__( 'Credit Card Payment', 'hotelian' ),
                'subtitle'    => esc_html__( 'Enable Credit Card payment through PayPal in booking step. Please note your paypal account should be business pro.', 'hotelian' ),
                'default'  => true,
            ),
            array(
                'id'       => 'ap_product_payment_paypal_sandbox',
                'type'     => 'switch',
                'title'    => esc_html__( 'Sandbox Mode ', 'hotelian' ),
                'subtitle'    => esc_html__( 'Enable PayPal sandbox for testing', 'hotelian' ),
                'default'  => true,
            ),
            array(
                'id'       => 'ap_product_payment_api_username',
                'type'     => 'text',
                'title'    => esc_html__( 'PayPal API Username', 'templaza-framework' ),
            ),
            array(
                'id'       => 'ap_product_payment_api_pass',
                'type'     => 'text',
                'title'    => esc_html__( 'PayPal API Password', 'templaza-framework' ),
            ),
            array(
                'id'       => 'ap_product_payment_api_signature',
                'type'     => 'text',
                'title'    => esc_html__( 'PayPal API Signature', 'templaza-framework' ),
            ),
            array(
                'id'       => 'ap_product-booking-email',
                'type'     => 'section',
                'title'    => esc_html__( 'Config Email', 'hotelian' ),
                'indent'  => true,
                'required' => array('ap_product-booking-enable', '=' , true)
            ),
            array(
                'title' => esc_html__('Subject', 'hotelian'),
                'subtitle' => esc_html__('Subject of email confirm send to customer.', 'hotelian'),
                'id' => 'ap_product_email_subject_customer',
                'default' => '',
                'type' => 'text'
            ),
            array(
                'title' => esc_html__('Content', 'hotelian'),
                'subtitle' => esc_html__('Content of email confirm send to customer.', 'hotelian'),
                'id' => 'ap_product_email_description_customer',
                'default' => '',
                'type' => 'editor'
            ),
            array(
                'title' => esc_html__('Order and Billing address option', 'hotelian'),
                'subtitle' => 'For email to customer',
                'id' => 'ap_product_email_confirm_customer_order_and_billing',
                'default' => true,
                'type' => 'switch'
            ),
            array(
                'id' => 'ap_product_email_confirm_customer_order_billing_position',
                'type' => 'select',
                'title' => esc_html__(' Position of Order and Billing Adress', 'hotelian'),
                'subtitle' => '',
                'default' => 'after',
                'options' => array(
                    'after' => esc_html__('After Content', 'hotelian'),
                    'before' => esc_html__('Before Content', 'hotelian'),
                ),
                'required' => array('ap_product_email_confirm_customer_order_and_billing', '=', true),
            ),
        ),
    )
);
Templaza_API::set_fields('settings', 'service-subsections',
    array(
        array(
            'id'       => 'hotelian_service_form',
            'type'     => 'select',
            'title'    => esc_html__( 'Service Book Form', 'hotelian' ),
            'options'  => $arr_wpform,
        ),
        array(
            'id'       => 'hotelian_service_form_custom',
            'type'     => 'text',
            'title'    => esc_html__( 'Custom Form', 'hotelian' ),
            'subtitle' => esc_html__('Insert Form Shortcode', 'hotelian'),
            'required' => array('hotelian_service_form', '=' , 'custom'),
        ),
    )
);