<?php
defined('ABSPATH') or exit();
use TemPlazaFramework\Functions;
if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' )){
    $options = array();
}else{
    $options            = Functions::get_theme_options();
}
$related_col      = isset($options['blog-related-column'])?$options['blog-related-column']:3;
$related_limit      = isset($options['blog-related-limit'])?$options['blog-related-limit']:3;
$related_nav      = isset($options['blog-related-nav']) ? $options['blog-related-nav'] : true;
$related_dot      = isset($options['blog-related-dot']) ? $options['blog-related-dot'] : true;

global $post;
$post_cats = wp_get_post_categories($post->ID);
if ($post_cats) {
    $post_cat_ids = array();
    foreach($post_cats as $post_cat_item) $post_cat_ids[] = $post_cat_item;
    $hotelian_args=array(
        'category__in'          => $post_cat_ids,
        'post__not_in'          => array($post->ID),
        'posts_per_page'        => $related_limit
    );
    $hotelian_query = new wp_query( $hotelian_args );
    if($hotelian_query->have_posts()){?>

        <div class="templaza-related-posts templaza-archive">
            <h3 class="box-title"><?php echo esc_html__('Related Posts','hotelian');?></h3>
            <div data-uk-slider>

                <div class="uk-position-relative">

                    <div class="uk-slider-container">
                        <div class="content-related uk-slider-items uk-grid uk-grid-medium uk-child-width-1-<?php echo esc_attr($related_col);?>@l uk-child-width-1-2@s">
                            <?php
                            while( $hotelian_query->have_posts() ) {
                                $hotelian_query->the_post();
                                $format = get_post_format($hotelian_query->post->ID) ? : 'standard';
                                ?>
                                <div class="templaza-blog-item uk-position-relative">
                                    <?php
                                    if(has_post_thumbnail($hotelian_query->post->ID)){
                                        ?>
                                        <div class="templaza-blog-item-wrap uk-margin-remove">
                                            <div class="uk-cover-container tz-img">
                                                <canvas width="400" height="300"></canvas>
                                                <a href="<?php the_permalink();?>">
                                                    <img src="<?php echo esc_url(get_the_post_thumbnail_url($hotelian_query->post->ID,'large'));?>" alt="" data-uk-cover>
                                                </a>
                                            </div>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                    <div class="templaza-blog-item-content">
                                        <div class="templaza-post-meta templaza-blog-item-info-top uk-margin-top">
                                            <span>
                                                 <i class="far fa-calendar-alt"></i>
                                                <?php echo esc_attr(get_the_date()); ?>
                                            </span>
                                            <span class="author">
                                                  <i class="far fa-user"></i>
                                                <?php echo wp_kses(get_the_author_posts_link(),'post');?>
                                            </span>
                                        </div>
                                        <h4>
                                            <a href="<?php the_permalink();?>">
                                                <?php the_title();?>
                                            </a>
                                        </h4>


                                    </div>
                                </div>
                                <?php
                            }
                            wp_reset_postdata();
                            ?>
                        </div>
                    </div>

                    <?php
                    if($related_nav){
                        ?>
                        <div class="">
                            <a class="uk-position-center-left uk-position-small" href="#" data-uk-slidenav-previous data-uk-slider-item="previous"></a>
                            <a class="uk-position-center-right uk-position-small" href="#" data-uk-slidenav-next data-uk-slider-item="next"></a>
                        </div>

                        <?php
                    }
                    ?>

                </div>

                <?php if($related_dot){
                    ?>
                    <ul class="uk-slider-nav uk-dotnav uk-flex-center"></ul>
                    <?php
                }
                ?>

            </div>

        </div>
        <?php
    }
}