<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

$classes = wc_get_product_class( '', $product  );
if(!class_exists( 'TemPlazaFramework\TemPlazaFramework' ) && class_exists( 'woocommerce' )){
    $classes = apply_filters( 'hotelian_single_product_summary_classes', $classes );
}else{
    $classes = apply_filters( 'templaza_single_product_summary_classes', $classes );
}


?>
<div class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">

	<?php
	/**
	 * Hook: woocommerce_before_single_product_summary.
	 *
	 * @hooked woocommerce_show_product_sale_flash - 10
	 * @hooked woocommerce_show_product_images - 20
	 */
    if(!class_exists( 'TemPlazaFramework\TemPlazaFramework' ) && class_exists( 'woocommerce' )){
        do_action( 'hotelian_woocommerce_before_single_product_summary' );
    }else{
        do_action( 'templaza_woocommerce_before_single_product_summary' );
    }
	?>

	<div class="summary entry-summary">
		<?php
		/**
		 * Hook: woocommerce_single_product_summary.
		 *
		 * @hooked woocommerce_template_single_title - 5
		 * @hooked woocommerce_template_single_rating - 10
		 * @hooked woocommerce_template_single_price - 10
		 * @hooked woocommerce_template_single_excerpt - 20
		 * @hooked woocommerce_template_single_add_to_cart - 30
		 * @hooked woocommerce_template_single_meta - 40
		 * @hooked woocommerce_template_single_sharing - 50
		 * @hooked WC_Structured_Data::generate_product_data() - 60
		 */
        if(!class_exists( 'TemPlazaFramework\TemPlazaFramework' ) && class_exists( 'woocommerce' )){
            do_action( 'hotelian_woocommerce_single_product_summary' );
        }else{
            do_action( 'templaza_woocommerce_single_product_summary' );
        }
		?>
	</div>
</div>
