<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

use Hotelian_Woo\Hotelian_Woo_Helper;
use TemPlaza_Woo\Templaza_Woo_Helper;

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
if(!class_exists( 'TemPlazaFramework\TemPlazaFramework' ) && class_exists( 'woocommerce' )){
    $post_thumbnail_id = apply_filters(	'hotelian_single_product_image_id', $product->get_image_id());
}else{
    $post_thumbnail_id = apply_filters(	'templaza_single_product_image_id', $product->get_image_id());
}

$wrapper_classes   = apply_filters(
	'woocommerce_single_product_image_gallery_classes',
	array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ( $post_thumbnail_id ? 'with-images' : 'without-images' ),
		'woocommerce-product-gallery--columns-' . absint( $columns ),
		'images',
	)
);

$video_position       = get_post_meta( $product->get_id(), 'video_position', true );
?>
<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-video="<?php echo esc_attr( $video_position ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>">
	<?php
    if(!class_exists( 'TemPlazaFramework\TemPlazaFramework' ) && class_exists( 'woocommerce' )){
        do_action( 'hotelian_before_product_gallery' );
    }else{
        do_action( 'templaza_before_product_gallery' );
    }
    ?>
	
	<figure class="woocommerce-product-gallery__wrapper">
		<?php

		if ( $video_position == '1' && is_singular( 'product' ) ) {

            if(!class_exists( 'TemPlazaFramework\TemPlazaFramework' ) && class_exists( 'woocommerce' )){
                echo Hotelian_Woo\Hotelian_Woo_Helper::hotelian_get_product_video();
            }else{
                echo Templaza_Woo\Templaza_Woo_Helper::templaza_get_product_video();
            }
		}

		if ( $product->get_image_id() ) {
			$html = wc_get_gallery_image_html( $post_thumbnail_id, true );
		} else {
			$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
			$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'hotelian' ) );
			$html .= '</div>';
		}

		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id );

		do_action( 'woocommerce_product_thumbnails' );
		?>
	</figure>
</div>
