<?php
/*This file is part of hotelian-child, hotelian child theme.

All functions of this file will be loaded before of parent theme functions.
Learn more at https://codex.wordpress.org/Child_Themes.

Note: this function loads the parent stylesheet before, then child theme stylesheet
(leave it in place unless you know what you are doing.)
*/

if ( ! function_exists( 'hotelian_child_theme_enqueue_scripts' ) ) {
	/**
	 * Function that enqueue theme's child style
	 */
	function hotelian_child_theme_enqueue_scripts() {
		$parent_style = 'hotelian-main';
        wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
        wp_enqueue_style( 'hotelian-child-style',
            get_stylesheet_directory_uri() . '/style.css',
            array( $parent_style )
        );
		
	}

	add_action( 'wp_enqueue_scripts', 'hotelian_child_theme_enqueue_scripts' );
}
/*Write here your own functions */
